/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch.transform.RetentionPolicyVariant;
import co.elastic.clients.elasticsearch.transform.TimeRetentionPolicy;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class RetentionPolicy
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<RetentionPolicy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RetentionPolicy::setupRetentionPolicyDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public RetentionPolicy(RetentionPolicyVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._retentionPolicyKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private RetentionPolicy(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static RetentionPolicy of(Function<Builder, ObjectBuilder<RetentionPolicy>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isTime() {
        return this._kind == Kind.Time;
    }

    public TimeRetentionPolicy time() {
        return (TimeRetentionPolicy)TaggedUnionUtils.get(this, Kind.Time);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupRetentionPolicyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::time, TimeRetentionPolicy._DESERIALIZER, "time");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RetentionPolicy> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<RetentionPolicy> time(TimeRetentionPolicy v) {
            this._kind = Kind.Time;
            this._value = v;
            return this;
        }

        public ObjectBuilder<RetentionPolicy> time(Function<TimeRetentionPolicy.Builder, ObjectBuilder<TimeRetentionPolicy>> fn) {
            return this.time(fn.apply(new TimeRetentionPolicy.Builder()).build());
        }

        @Override
        public RetentionPolicy build() {
            this._checkSingleUse();
            return new RetentionPolicy(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Time("time");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

