/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.slm.DeleteLifecycleRequest;
import co.elastic.clients.elasticsearch.slm.DeleteLifecycleResponse;
import co.elastic.clients.elasticsearch.slm.ExecuteLifecycleRequest;
import co.elastic.clients.elasticsearch.slm.ExecuteLifecycleResponse;
import co.elastic.clients.elasticsearch.slm.ExecuteRetentionRequest;
import co.elastic.clients.elasticsearch.slm.ExecuteRetentionResponse;
import co.elastic.clients.elasticsearch.slm.GetLifecycleRequest;
import co.elastic.clients.elasticsearch.slm.GetLifecycleResponse;
import co.elastic.clients.elasticsearch.slm.GetSlmStatusRequest;
import co.elastic.clients.elasticsearch.slm.GetSlmStatusResponse;
import co.elastic.clients.elasticsearch.slm.GetStatsRequest;
import co.elastic.clients.elasticsearch.slm.GetStatsResponse;
import co.elastic.clients.elasticsearch.slm.PutLifecycleRequest;
import co.elastic.clients.elasticsearch.slm.PutLifecycleResponse;
import co.elastic.clients.elasticsearch.slm.StartSlmRequest;
import co.elastic.clients.elasticsearch.slm.StartSlmResponse;
import co.elastic.clients.elasticsearch.slm.StopSlmRequest;
import co.elastic.clients.elasticsearch.slm.StopSlmResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchSlmAsyncClient
extends ApiClient<ElasticsearchTransport, ElasticsearchSlmAsyncClient> {
    public ElasticsearchSlmAsyncClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchSlmAsyncClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchSlmAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchSlmAsyncClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<DeleteLifecycleResponse> deleteLifecycle(DeleteLifecycleRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)DeleteLifecycleRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<DeleteLifecycleResponse> deleteLifecycle(Function<DeleteLifecycleRequest.Builder, ObjectBuilder<DeleteLifecycleRequest>> fn) throws IOException, ElasticsearchException {
        return this.deleteLifecycle(fn.apply(new DeleteLifecycleRequest.Builder()).build());
    }

    public CompletableFuture<ExecuteLifecycleResponse> executeLifecycle(ExecuteLifecycleRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)ExecuteLifecycleRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<ExecuteLifecycleResponse> executeLifecycle(Function<ExecuteLifecycleRequest.Builder, ObjectBuilder<ExecuteLifecycleRequest>> fn) throws IOException, ElasticsearchException {
        return this.executeLifecycle(fn.apply(new ExecuteLifecycleRequest.Builder()).build());
    }

    public CompletableFuture<ExecuteRetentionResponse> executeRetention() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(ExecuteRetentionRequest._INSTANCE, ExecuteRetentionRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<GetLifecycleResponse> getLifecycle(GetLifecycleRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)GetLifecycleRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetLifecycleResponse> getLifecycle(Function<GetLifecycleRequest.Builder, ObjectBuilder<GetLifecycleRequest>> fn) throws IOException, ElasticsearchException {
        return this.getLifecycle(fn.apply(new GetLifecycleRequest.Builder()).build());
    }

    public CompletableFuture<GetLifecycleResponse> getLifecycle() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new GetLifecycleRequest.Builder().build(), GetLifecycleRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<GetStatsResponse> getStats() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(GetStatsRequest._INSTANCE, GetStatsRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<GetSlmStatusResponse> getStatus() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(GetSlmStatusRequest._INSTANCE, GetSlmStatusRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<PutLifecycleResponse> putLifecycle(PutLifecycleRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)PutLifecycleRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<PutLifecycleResponse> putLifecycle(Function<PutLifecycleRequest.Builder, ObjectBuilder<PutLifecycleRequest>> fn) throws IOException, ElasticsearchException {
        return this.putLifecycle(fn.apply(new PutLifecycleRequest.Builder()).build());
    }

    public CompletableFuture<StartSlmResponse> start() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(StartSlmRequest._INSTANCE, StartSlmRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<StopSlmResponse> stop() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(StopSlmRequest._INSTANCE, StopSlmRequest._ENDPOINT, this.transportOptions);
    }
}

