/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.preview_data_frame_analytics;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysis;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisAnalyzedFields;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsSource;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataframePreviewConfig
implements JsonpSerializable {
    private final DataframeAnalyticsSource source;
    private final DataframeAnalysis analysis;
    @Nullable
    private final String modelMemoryLimit;
    @Nullable
    private final Integer maxNumThreads;
    @Nullable
    private final DataframeAnalysisAnalyzedFields analyzedFields;
    public static final JsonpDeserializer<DataframePreviewConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframePreviewConfig::setupDataframePreviewConfigDeserializer);

    private DataframePreviewConfig(Builder builder) {
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
        this.analysis = ApiTypeHelper.requireNonNull(builder.analysis, this, "analysis");
        this.modelMemoryLimit = builder.modelMemoryLimit;
        this.maxNumThreads = builder.maxNumThreads;
        this.analyzedFields = builder.analyzedFields;
    }

    public static DataframePreviewConfig of(Function<Builder, ObjectBuilder<DataframePreviewConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final DataframeAnalyticsSource source() {
        return this.source;
    }

    public final DataframeAnalysis analysis() {
        return this.analysis;
    }

    @Nullable
    public final String modelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    @Nullable
    public final Integer maxNumThreads() {
        return this.maxNumThreads;
    }

    @Nullable
    public final DataframeAnalysisAnalyzedFields analyzedFields() {
        return this.analyzedFields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("source");
        this.source.serialize(generator, mapper);
        generator.writeKey("analysis");
        this.analysis.serialize(generator, mapper);
        if (this.modelMemoryLimit != null) {
            generator.writeKey("model_memory_limit");
            generator.write(this.modelMemoryLimit);
        }
        if (this.maxNumThreads != null) {
            generator.writeKey("max_num_threads");
            generator.write(this.maxNumThreads.intValue());
        }
        if (this.analyzedFields != null) {
            generator.writeKey("analyzed_fields");
            this.analyzedFields.serialize(generator, mapper);
        }
    }

    protected static void setupDataframePreviewConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::source, DataframeAnalyticsSource._DESERIALIZER, "source");
        op.add(Builder::analysis, DataframeAnalysis._DESERIALIZER, "analysis");
        op.add(Builder::modelMemoryLimit, JsonpDeserializer.stringDeserializer(), "model_memory_limit");
        op.add(Builder::maxNumThreads, JsonpDeserializer.integerDeserializer(), "max_num_threads");
        op.add(Builder::analyzedFields, DataframeAnalysisAnalyzedFields._DESERIALIZER, "analyzed_fields");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DataframePreviewConfig> {
        private DataframeAnalyticsSource source;
        private DataframeAnalysis analysis;
        @Nullable
        private String modelMemoryLimit;
        @Nullable
        private Integer maxNumThreads;
        @Nullable
        private DataframeAnalysisAnalyzedFields analyzedFields;

        public final Builder source(DataframeAnalyticsSource value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<DataframeAnalyticsSource.Builder, ObjectBuilder<DataframeAnalyticsSource>> fn) {
            return this.source(fn.apply(new DataframeAnalyticsSource.Builder()).build());
        }

        public final Builder analysis(DataframeAnalysis value) {
            this.analysis = value;
            return this;
        }

        public final Builder analysis(Function<DataframeAnalysis.Builder, ObjectBuilder<DataframeAnalysis>> fn) {
            return this.analysis(fn.apply(new DataframeAnalysis.Builder()).build());
        }

        public final Builder modelMemoryLimit(@Nullable String value) {
            this.modelMemoryLimit = value;
            return this;
        }

        public final Builder maxNumThreads(@Nullable Integer value) {
            this.maxNumThreads = value;
            return this;
        }

        public final Builder analyzedFields(@Nullable DataframeAnalysisAnalyzedFields value) {
            this.analyzedFields = value;
            return this;
        }

        public final Builder analyzedFields(Function<DataframeAnalysisAnalyzedFields.Builder, ObjectBuilder<DataframeAnalysisAnalyzedFields>> fn) {
            return this.analyzedFields(fn.apply(new DataframeAnalysisAnalyzedFields.Builder()).build());
        }

        @Override
        public DataframePreviewConfig build() {
            this._checkSingleUse();
            return new DataframePreviewConfig(this);
        }
    }
}

