/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class OverallBucketJob
implements JsonpSerializable {
    private final String jobId;
    private final double maxAnomalyScore;
    public static final JsonpDeserializer<OverallBucketJob> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OverallBucketJob::setupOverallBucketJobDeserializer);

    private OverallBucketJob(Builder builder) {
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.maxAnomalyScore = ApiTypeHelper.requireNonNull(builder.maxAnomalyScore, this, "maxAnomalyScore");
    }

    public static OverallBucketJob of(Function<Builder, ObjectBuilder<OverallBucketJob>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String jobId() {
        return this.jobId;
    }

    public final double maxAnomalyScore() {
        return this.maxAnomalyScore;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("max_anomaly_score");
        generator.write(this.maxAnomalyScore);
    }

    protected static void setupOverallBucketJobDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::maxAnomalyScore, JsonpDeserializer.doubleDeserializer(), "max_anomaly_score");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<OverallBucketJob> {
        private String jobId;
        private Double maxAnomalyScore;

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder maxAnomalyScore(double value) {
            this.maxAnomalyScore = value;
            return this;
        }

        @Override
        public OverallBucketJob build() {
            this._checkSingleUse();
            return new OverallBucketJob(this);
        }
    }
}

