/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.DataframeClassificationSummary;
import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.DataframeOutlierDetectionSummary;
import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.DataframeRegressionSummary;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class EvaluateDataFrameResponse
implements JsonpSerializable {
    @Nullable
    private final DataframeClassificationSummary classification;
    @Nullable
    private final DataframeOutlierDetectionSummary outlierDetection;
    @Nullable
    private final DataframeRegressionSummary regression;
    public static final JsonpDeserializer<EvaluateDataFrameResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EvaluateDataFrameResponse::setupEvaluateDataFrameResponseDeserializer);

    private EvaluateDataFrameResponse(Builder builder) {
        this.classification = builder.classification;
        this.outlierDetection = builder.outlierDetection;
        this.regression = builder.regression;
    }

    public static EvaluateDataFrameResponse of(Function<Builder, ObjectBuilder<EvaluateDataFrameResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DataframeClassificationSummary classification() {
        return this.classification;
    }

    @Nullable
    public final DataframeOutlierDetectionSummary outlierDetection() {
        return this.outlierDetection;
    }

    @Nullable
    public final DataframeRegressionSummary regression() {
        return this.regression;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.classification != null) {
            generator.writeKey("classification");
            this.classification.serialize(generator, mapper);
        }
        if (this.outlierDetection != null) {
            generator.writeKey("outlier_detection");
            this.outlierDetection.serialize(generator, mapper);
        }
        if (this.regression != null) {
            generator.writeKey("regression");
            this.regression.serialize(generator, mapper);
        }
    }

    protected static void setupEvaluateDataFrameResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::classification, DataframeClassificationSummary._DESERIALIZER, "classification");
        op.add(Builder::outlierDetection, DataframeOutlierDetectionSummary._DESERIALIZER, "outlier_detection");
        op.add(Builder::regression, DataframeRegressionSummary._DESERIALIZER, "regression");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<EvaluateDataFrameResponse> {
        @Nullable
        private DataframeClassificationSummary classification;
        @Nullable
        private DataframeOutlierDetectionSummary outlierDetection;
        @Nullable
        private DataframeRegressionSummary regression;

        public final Builder classification(@Nullable DataframeClassificationSummary value) {
            this.classification = value;
            return this;
        }

        public final Builder classification(Function<DataframeClassificationSummary.Builder, ObjectBuilder<DataframeClassificationSummary>> fn) {
            return this.classification(fn.apply(new DataframeClassificationSummary.Builder()).build());
        }

        public final Builder outlierDetection(@Nullable DataframeOutlierDetectionSummary value) {
            this.outlierDetection = value;
            return this;
        }

        public final Builder outlierDetection(Function<DataframeOutlierDetectionSummary.Builder, ObjectBuilder<DataframeOutlierDetectionSummary>> fn) {
            return this.outlierDetection(fn.apply(new DataframeOutlierDetectionSummary.Builder()).build());
        }

        public final Builder regression(@Nullable DataframeRegressionSummary value) {
            this.regression = value;
            return this;
        }

        public final Builder regression(Function<DataframeRegressionSummary.Builder, ObjectBuilder<DataframeRegressionSummary>> fn) {
            return this.regression(fn.apply(new DataframeRegressionSummary.Builder()).build());
        }

        @Override
        public EvaluateDataFrameResponse build() {
            this._checkSingleUse();
            return new EvaluateDataFrameResponse(this);
        }
    }
}

