/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DatafeedState;
import co.elastic.clients.elasticsearch.ml.DatafeedTimingStats;
import co.elastic.clients.elasticsearch.ml.DiscoveryNode;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DatafeedStats
implements JsonpSerializable {
    private final String assignmentExplanation;
    private final String datafeedId;
    private final DiscoveryNode node;
    private final DatafeedState state;
    private final DatafeedTimingStats timingStats;
    public static final JsonpDeserializer<DatafeedStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DatafeedStats::setupDatafeedStatsDeserializer);

    private DatafeedStats(Builder builder) {
        this.assignmentExplanation = ApiTypeHelper.requireNonNull(builder.assignmentExplanation, this, "assignmentExplanation");
        this.datafeedId = ApiTypeHelper.requireNonNull(builder.datafeedId, this, "datafeedId");
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
        this.timingStats = ApiTypeHelper.requireNonNull(builder.timingStats, this, "timingStats");
    }

    public static DatafeedStats of(Function<Builder, ObjectBuilder<DatafeedStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String assignmentExplanation() {
        return this.assignmentExplanation;
    }

    public final String datafeedId() {
        return this.datafeedId;
    }

    public final DiscoveryNode node() {
        return this.node;
    }

    public final DatafeedState state() {
        return this.state;
    }

    public final DatafeedTimingStats timingStats() {
        return this.timingStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("assignment_explanation");
        generator.write(this.assignmentExplanation);
        generator.writeKey("datafeed_id");
        generator.write(this.datafeedId);
        generator.writeKey("node");
        this.node.serialize(generator, mapper);
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        generator.writeKey("timing_stats");
        this.timingStats.serialize(generator, mapper);
    }

    protected static void setupDatafeedStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::assignmentExplanation, JsonpDeserializer.stringDeserializer(), "assignment_explanation");
        op.add(Builder::datafeedId, JsonpDeserializer.stringDeserializer(), "datafeed_id");
        op.add(Builder::node, DiscoveryNode._DESERIALIZER, "node");
        op.add(Builder::state, DatafeedState._DESERIALIZER, "state");
        op.add(Builder::timingStats, DatafeedTimingStats._DESERIALIZER, "timing_stats");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DatafeedStats> {
        private String assignmentExplanation;
        private String datafeedId;
        private DiscoveryNode node;
        private DatafeedState state;
        private DatafeedTimingStats timingStats;

        public final Builder assignmentExplanation(String value) {
            this.assignmentExplanation = value;
            return this;
        }

        public final Builder datafeedId(String value) {
            this.datafeedId = value;
            return this;
        }

        public final Builder node(DiscoveryNode value) {
            this.node = value;
            return this;
        }

        public final Builder node(Function<DiscoveryNode.Builder, ObjectBuilder<DiscoveryNode>> fn) {
            return this.node(fn.apply(new DiscoveryNode.Builder()).build());
        }

        public final Builder state(DatafeedState value) {
            this.state = value;
            return this;
        }

        public final Builder timingStats(DatafeedTimingStats value) {
            this.timingStats = value;
            return this;
        }

        public final Builder timingStats(Function<DatafeedTimingStats.Builder, ObjectBuilder<DatafeedTimingStats>> fn) {
            return this.timingStats(fn.apply(new DatafeedTimingStats.Builder()).build());
        }

        @Override
        public DatafeedStats build() {
            this._checkSingleUse();
            return new DatafeedStats(this);
        }
    }
}

