/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FieldTypes
implements JsonpSerializable {
    private final String name;
    private final int count;
    private final int indexCount;
    @Nullable
    private final Integer scriptCount;
    public static final JsonpDeserializer<FieldTypes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldTypes::setupFieldTypesDeserializer);

    private FieldTypes(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.indexCount = ApiTypeHelper.requireNonNull(builder.indexCount, this, "indexCount");
        this.scriptCount = builder.scriptCount;
    }

    public static FieldTypes of(Function<Builder, ObjectBuilder<FieldTypes>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final int count() {
        return this.count;
    }

    public final int indexCount() {
        return this.indexCount;
    }

    @Nullable
    public final Integer scriptCount() {
        return this.scriptCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("index_count");
        generator.write(this.indexCount);
        if (this.scriptCount != null) {
            generator.writeKey("script_count");
            generator.write(this.scriptCount.intValue());
        }
    }

    protected static void setupFieldTypesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::indexCount, JsonpDeserializer.integerDeserializer(), "index_count");
        op.add(Builder::scriptCount, JsonpDeserializer.integerDeserializer(), "script_count");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FieldTypes> {
        private String name;
        private Integer count;
        private Integer indexCount;
        @Nullable
        private Integer scriptCount;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder indexCount(int value) {
            this.indexCount = value;
            return this;
        }

        public final Builder scriptCount(@Nullable Integer value) {
            this.scriptCount = value;
            return this;
        }

        @Override
        public FieldTypes build() {
            this._checkSingleUse();
            return new FieldTypes(this);
        }
    }
}

