/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ClusterJvmMemory
implements JsonpSerializable {
    private final long heapMaxInBytes;
    private final long heapUsedInBytes;
    public static final JsonpDeserializer<ClusterJvmMemory> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterJvmMemory::setupClusterJvmMemoryDeserializer);

    private ClusterJvmMemory(Builder builder) {
        this.heapMaxInBytes = ApiTypeHelper.requireNonNull(builder.heapMaxInBytes, this, "heapMaxInBytes");
        this.heapUsedInBytes = ApiTypeHelper.requireNonNull(builder.heapUsedInBytes, this, "heapUsedInBytes");
    }

    public static ClusterJvmMemory of(Function<Builder, ObjectBuilder<ClusterJvmMemory>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long heapMaxInBytes() {
        return this.heapMaxInBytes;
    }

    public final long heapUsedInBytes() {
        return this.heapUsedInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("heap_max_in_bytes");
        generator.write(this.heapMaxInBytes);
        generator.writeKey("heap_used_in_bytes");
        generator.write(this.heapUsedInBytes);
    }

    protected static void setupClusterJvmMemoryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::heapMaxInBytes, JsonpDeserializer.longDeserializer(), "heap_max_in_bytes");
        op.add(Builder::heapUsedInBytes, JsonpDeserializer.longDeserializer(), "heap_used_in_bytes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ClusterJvmMemory> {
        private Long heapMaxInBytes;
        private Long heapUsedInBytes;

        public final Builder heapMaxInBytes(long value) {
            this.heapMaxInBytes = value;
            return this;
        }

        public final Builder heapUsedInBytes(long value) {
            this.heapUsedInBytes = value;
            return this;
        }

        @Override
        public ClusterJvmMemory build() {
            this._checkSingleUse();
            return new ClusterJvmMemory(this);
        }
    }
}

