/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.health;

import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ShardHealthStats
implements JsonpSerializable {
    private final int activeShards;
    private final int initializingShards;
    private final boolean primaryActive;
    private final int relocatingShards;
    private final HealthStatus status;
    private final int unassignedShards;
    public static final JsonpDeserializer<ShardHealthStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardHealthStats::setupShardHealthStatsDeserializer);

    private ShardHealthStats(Builder builder) {
        this.activeShards = ApiTypeHelper.requireNonNull(builder.activeShards, this, "activeShards");
        this.initializingShards = ApiTypeHelper.requireNonNull(builder.initializingShards, this, "initializingShards");
        this.primaryActive = ApiTypeHelper.requireNonNull(builder.primaryActive, this, "primaryActive");
        this.relocatingShards = ApiTypeHelper.requireNonNull(builder.relocatingShards, this, "relocatingShards");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.unassignedShards = ApiTypeHelper.requireNonNull(builder.unassignedShards, this, "unassignedShards");
    }

    public static ShardHealthStats of(Function<Builder, ObjectBuilder<ShardHealthStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int activeShards() {
        return this.activeShards;
    }

    public final int initializingShards() {
        return this.initializingShards;
    }

    public final boolean primaryActive() {
        return this.primaryActive;
    }

    public final int relocatingShards() {
        return this.relocatingShards;
    }

    public final HealthStatus status() {
        return this.status;
    }

    public final int unassignedShards() {
        return this.unassignedShards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active_shards");
        generator.write(this.activeShards);
        generator.writeKey("initializing_shards");
        generator.write(this.initializingShards);
        generator.writeKey("primary_active");
        generator.write(this.primaryActive);
        generator.writeKey("relocating_shards");
        generator.write(this.relocatingShards);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("unassigned_shards");
        generator.write(this.unassignedShards);
    }

    protected static void setupShardHealthStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::activeShards, JsonpDeserializer.integerDeserializer(), "active_shards");
        op.add(Builder::initializingShards, JsonpDeserializer.integerDeserializer(), "initializing_shards");
        op.add(Builder::primaryActive, JsonpDeserializer.booleanDeserializer(), "primary_active");
        op.add(Builder::relocatingShards, JsonpDeserializer.integerDeserializer(), "relocating_shards");
        op.add(Builder::status, HealthStatus._DESERIALIZER, "status");
        op.add(Builder::unassignedShards, JsonpDeserializer.integerDeserializer(), "unassigned_shards");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ShardHealthStats> {
        private Integer activeShards;
        private Integer initializingShards;
        private Boolean primaryActive;
        private Integer relocatingShards;
        private HealthStatus status;
        private Integer unassignedShards;

        public final Builder activeShards(int value) {
            this.activeShards = value;
            return this;
        }

        public final Builder initializingShards(int value) {
            this.initializingShards = value;
            return this;
        }

        public final Builder primaryActive(boolean value) {
            this.primaryActive = value;
            return this;
        }

        public final Builder relocatingShards(int value) {
            this.relocatingShards = value;
            return this;
        }

        public final Builder status(HealthStatus value) {
            this.status = value;
            return this;
        }

        public final Builder unassignedShards(int value) {
            this.unassignedShards = value;
            return this;
        }

        @Override
        public ShardHealthStats build() {
            this._checkSingleUse();
            return new ShardHealthStats(this);
        }
    }
}

