/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.elasticsearch.ccr.ShardStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class FollowIndexStats
implements JsonpSerializable {
    private final String index;
    private final List<ShardStats> shards;
    public static final JsonpDeserializer<FollowIndexStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FollowIndexStats::setupFollowIndexStatsDeserializer);

    private FollowIndexStats(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.shards = ApiTypeHelper.unmodifiableRequired(builder.shards, (Object)this, "shards");
    }

    public static FollowIndexStats of(Function<Builder, ObjectBuilder<FollowIndexStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    public final List<ShardStats> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartArray();
            for (ShardStats item0 : this.shards) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupFollowIndexStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::shards, JsonpDeserializer.arrayDeserializer(ShardStats._DESERIALIZER), "shards");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FollowIndexStats> {
        private String index;
        private List<ShardStats> shards;

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder shards(List<ShardStats> list) {
            this.shards = Builder._listAddAll(this.shards, list);
            return this;
        }

        public final Builder shards(ShardStats value, ShardStats ... values) {
            this.shards = Builder._listAdd(this.shards, value, values);
            return this;
        }

        public final Builder shards(Function<ShardStats.Builder, ObjectBuilder<ShardStats>> fn) {
            return this.shards(fn.apply(new ShardStats.Builder()).build(), new ShardStats[0]);
        }

        @Override
        public FollowIndexStats build() {
            this._checkSingleUse();
            return new FollowIndexStats(this);
        }
    }
}

