/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.MlJobsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class MlJobsRequest
extends CatRequestBase {
    @Nullable
    private final Boolean allowNoJobs;
    @Nullable
    private final Bytes bytes;
    @Nullable
    private final String jobId;
    public static final Endpoint<MlJobsRequest, MlJobsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<MlJobsRequest, MlJobsResponse>("es/cat.ml_jobs", request -> "GET", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (request.jobId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/anomaly_detectors");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.allowNoJobs != null) {
            params.put("allow_no_jobs", String.valueOf(request.allowNoJobs));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, MlJobsResponse._DESERIALIZER);

    private MlJobsRequest(Builder builder) {
        this.allowNoJobs = builder.allowNoJobs;
        this.bytes = builder.bytes;
        this.jobId = builder.jobId;
    }

    public static MlJobsRequest of(Function<Builder, ObjectBuilder<MlJobsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Deprecated
    @Nullable
    public final Boolean allowNoJobs() {
        return this.allowNoJobs;
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    @Nullable
    public final String jobId() {
        return this.jobId;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MlJobsRequest> {
        @Nullable
        private Boolean allowNoJobs;
        @Nullable
        private Bytes bytes;
        @Nullable
        private String jobId;

        @Deprecated
        public final Builder allowNoJobs(@Nullable Boolean value) {
            this.allowNoJobs = value;
            return this;
        }

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder jobId(@Nullable String value) {
            this.jobId = value;
            return this;
        }

        @Override
        public MlJobsRequest build() {
            this._checkSingleUse();
            return new MlJobsRequest(this);
        }
    }
}

