/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregateBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import jakarta.json.stream.JsonGenerator;

public abstract class SingleBucketAggregateBase
extends AggregateBase {
    private final long docCount;

    protected SingleBucketAggregateBase(AbstractBuilder<?> builder) {
        super(builder);
        this.docCount = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).docCount, this, "docCount");
    }

    public final long docCount() {
        return this.docCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("doc_count");
        generator.write(this.docCount);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSingleBucketAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(AbstractBuilder::docCount, JsonpDeserializer.longDeserializer(), "doc_count");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregateBase.AbstractBuilder<BuilderT> {
        private Long docCount;

        protected AbstractBuilder() {
        }

        public final BuilderT docCount(long value) {
            this.docCount = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

