/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SlicedScroll
implements JsonpSerializable {
    @Nullable
    private final String field;
    private final int id;
    private final int max;
    public static final JsonpDeserializer<SlicedScroll> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SlicedScroll::setupSlicedScrollDeserializer);

    private SlicedScroll(Builder builder) {
        this.field = builder.field;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.max = ApiTypeHelper.requireNonNull(builder.max, this, "max");
    }

    public static SlicedScroll of(Function<Builder, ObjectBuilder<SlicedScroll>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    public final int id() {
        return this.id;
    }

    public final int max() {
        return this.max;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("max");
        generator.write(this.max);
    }

    protected static void setupSlicedScrollDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::id, JsonpDeserializer.integerDeserializer(), "id");
        op.add(Builder::max, JsonpDeserializer.integerDeserializer(), "max");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SlicedScroll> {
        @Nullable
        private String field;
        private Integer id;
        private Integer max;

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder id(int value) {
            this.id = value;
            return this;
        }

        public final Builder max(int value) {
            this.max = value;
            return this;
        }

        @Override
        public SlicedScroll build() {
            this._checkSingleUse();
            return new SlicedScroll(this);
        }
    }
}

