/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.endpoints;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class DictionaryResponse<TKey, TValue>
implements JsonpSerializable {
    private final Map<String, TValue> result;
    @Nullable
    private final JsonpSerializer<TKey> tKeySerializer;
    @Nullable
    private final JsonpSerializer<TValue> tValueSerializer;

    protected DictionaryResponse(AbstractBuilder<TKey, TValue, ?> builder) {
        this.result = ((AbstractBuilder)builder).result;
        this.tKeySerializer = ((AbstractBuilder)builder).tKeySerializer;
        this.tValueSerializer = ((AbstractBuilder)builder).tValueSerializer;
    }

    public Map<String, TValue> result() {
        return this.result == null ? Collections.emptyMap() : this.result;
    }

    public TValue get(String key) {
        return this.result == null ? null : (TValue)this.result.get(key);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, TValue> item0 : this.result.entrySet()) {
            generator.writeKey(item0.getKey());
            JsonpUtils.serialize(item0.getValue(), generator, this.tValueSerializer, mapper);
        }
    }

    protected static <TKey, TValue, BuilderT extends AbstractBuilder<TKey, TValue, BuilderT>> void setupDictionaryResponseDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TKey> tKeyParser, JsonpDeserializer<TValue> tValueParser) {
        op.setUnknownFieldHandler((builder, name, parser, params) -> builder.putResult((String)name, tValueParser.deserialize((JsonParser)parser, (JsonpMapper)params)));
    }

    protected static abstract class AbstractBuilder<TKey, TValue, BuilderT extends AbstractBuilder<TKey, TValue, BuilderT>>
    extends ObjectBuilderBase {
        private Map<String, TValue> result;
        @Nullable
        private JsonpSerializer<TKey> tKeySerializer;
        @Nullable
        private JsonpSerializer<TValue> tValueSerializer;

        protected AbstractBuilder() {
        }

        public BuilderT result(Map<String, TValue> value) {
            this.result = value;
            return this.self();
        }

        public BuilderT putResult(String key, TValue value) {
            if (this.result == null) {
                this.result = new HashMap<String, TValue>();
            }
            this.result.put(key, value);
            return this.self();
        }

        public BuilderT tKeySerializer(@Nullable JsonpSerializer<TKey> value) {
            this.tKeySerializer = value;
            return this.self();
        }

        public BuilderT tValueSerializer(@Nullable JsonpSerializer<TValue> value) {
            this.tValueSerializer = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

