/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ShardSequenceNumber
implements JsonpSerializable {
    private final long globalCheckpoint;
    private final long localCheckpoint;
    private final long maxSeqNo;
    public static final JsonpDeserializer<ShardSequenceNumber> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardSequenceNumber::setupShardSequenceNumberDeserializer);

    private ShardSequenceNumber(Builder builder) {
        this.globalCheckpoint = ApiTypeHelper.requireNonNull(builder.globalCheckpoint, this, "globalCheckpoint");
        this.localCheckpoint = ApiTypeHelper.requireNonNull(builder.localCheckpoint, this, "localCheckpoint");
        this.maxSeqNo = ApiTypeHelper.requireNonNull(builder.maxSeqNo, this, "maxSeqNo");
    }

    public static ShardSequenceNumber of(Function<Builder, ObjectBuilder<ShardSequenceNumber>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long globalCheckpoint() {
        return this.globalCheckpoint;
    }

    public final long localCheckpoint() {
        return this.localCheckpoint;
    }

    public final long maxSeqNo() {
        return this.maxSeqNo;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("global_checkpoint");
        generator.write(this.globalCheckpoint);
        generator.writeKey("local_checkpoint");
        generator.write(this.localCheckpoint);
        generator.writeKey("max_seq_no");
        generator.write(this.maxSeqNo);
    }

    protected static void setupShardSequenceNumberDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::globalCheckpoint, JsonpDeserializer.longDeserializer(), "global_checkpoint");
        op.add(Builder::localCheckpoint, JsonpDeserializer.longDeserializer(), "local_checkpoint");
        op.add(Builder::maxSeqNo, JsonpDeserializer.longDeserializer(), "max_seq_no");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ShardSequenceNumber> {
        private Long globalCheckpoint;
        private Long localCheckpoint;
        private Long maxSeqNo;

        public final Builder globalCheckpoint(long value) {
            this.globalCheckpoint = value;
            return this;
        }

        public final Builder localCheckpoint(long value) {
            this.localCheckpoint = value;
            return this;
        }

        public final Builder maxSeqNo(long value) {
            this.maxSeqNo = value;
            return this;
        }

        @Override
        public ShardSequenceNumber build() {
            this._checkSingleUse();
            return new ShardSequenceNumber(this);
        }
    }
}

