/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.util;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public interface StringEnum
extends JsonpSerializable {
    public String jsonValue();

    @Override
    default public void serialize(JsonGenerator generator, JsonpMapper params) {
        generator.write(this.jsonValue());
    }

    public static class Deserializer<T extends Enum<T>>
    extends JsonpDeserializer<T> {
        private final Map<String, T> lookupTable;

        public Deserializer(T[] values) {
            super(EnumSet.of(JsonParser.Event.VALUE_STRING));
            this.lookupTable = new HashMap<String, T>((int)((float)values.length / 0.75f) + 1);
            for (T member : values) {
                this.lookupTable.put(((StringEnum)member).jsonValue(), member);
            }
        }

        @Override
        public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            String value = parser.getString();
            return this.deserialize(value, parser);
        }

        public T deserialize(String value, JsonParser parser) {
            Enum result = (Enum)this.lookupTable.get(value);
            if (result == null) {
                throw new JsonParsingException("Invalid enum [" + value + "]", parser.getLocation());
            }
            return (T)result;
        }

        public T parse(String value) {
            Enum result = (Enum)this.lookupTable.get(value);
            if (result == null) {
                throw new NoSuchElementException("Invalid enum [" + value + "]");
            }
            return (T)result;
        }
    }
}

