/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.util;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpUtils;
import jakarta.json.stream.JsonParser;
import java.util.EnumSet;
import java.util.function.Supplier;

public class NamedValue<T> {
    private final String name;
    private final T value;

    public NamedValue(String name, T value) {
        this.name = name;
        this.value = value;
    }

    public String name() {
        return this.name;
    }

    public T value() {
        return this.value;
    }

    public static <T> JsonpDeserializer<NamedValue<T>> deserializer(final Supplier<JsonpDeserializer<T>> valueParserBuilder) {
        return new JsonpDeserializer<NamedValue<T>>(EnumSet.of(JsonParser.Event.START_OBJECT)){

            @Override
            public NamedValue<T> deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                JsonpUtils.expectEvent(parser, JsonParser.Event.KEY_NAME, event);
                String name = parser.getString();
                Object value = ((JsonpDeserializer)valueParserBuilder.get()).deserialize(parser, mapper);
                JsonpUtils.expectNextEvent(parser, JsonParser.Event.END_OBJECT);
                return new NamedValue(name, value);
            }
        };
    }
}

