/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.elasticsearch.xpack.usage.Counter;
import co.elastic.clients.elasticsearch.xpack.usage.WatcherActions;
import co.elastic.clients.elasticsearch.xpack.usage.WatcherWatch;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Watcher
extends Base {
    private final WatcherActions execution;
    private final WatcherWatch watch;
    private final Counter count;
    public static final JsonpDeserializer<Watcher> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Watcher::setupWatcherDeserializer, Builder::build);

    public Watcher(Builder builder) {
        super(builder);
        this.execution = Objects.requireNonNull(builder.execution, "execution");
        this.watch = Objects.requireNonNull(builder.watch, "watch");
        this.count = Objects.requireNonNull(builder.count, "count");
    }

    public Watcher(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public WatcherActions execution() {
        return this.execution;
    }

    public WatcherWatch watch() {
        return this.watch;
    }

    public Counter count() {
        return this.count;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("execution");
        this.execution.serialize(generator, mapper);
        generator.writeKey("watch");
        this.watch.serialize(generator, mapper);
        generator.writeKey("count");
        this.count.serialize(generator, mapper);
    }

    protected static void setupWatcherDeserializer(DelegatingDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::execution, WatcherActions._DESERIALIZER, "execution", new String[0]);
        op.add(Builder::watch, WatcherWatch._DESERIALIZER, "watch", new String[0]);
        op.add(Builder::count, Counter._DESERIALIZER, "count", new String[0]);
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Watcher> {
        private WatcherActions execution;
        private WatcherWatch watch;
        private Counter count;

        public Builder execution(WatcherActions value) {
            this.execution = value;
            return this;
        }

        public Builder execution(Function<WatcherActions.Builder, ObjectBuilder<WatcherActions>> fn) {
            return this.execution(fn.apply(new WatcherActions.Builder()).build());
        }

        public Builder watch(WatcherWatch value) {
            this.watch = value;
            return this;
        }

        public Builder watch(Function<WatcherWatch.Builder, ObjectBuilder<WatcherWatch>> fn) {
            return this.watch(fn.apply(new WatcherWatch.Builder()).build());
        }

        public Builder count(Counter value) {
            this.count = value;
            return this;
        }

        public Builder count(Function<Counter.Builder, ObjectBuilder<Counter>> fn) {
            return this.count(fn.apply(new Counter.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Watcher build() {
            return new Watcher(this);
        }
    }
}

