/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.elasticsearch.xpack.usage.Query;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class Sql
extends Base {
    private final Map<String, Integer> features;
    private final Map<String, Query> queries;
    public static final JsonpDeserializer<Sql> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Sql::setupSqlDeserializer, Builder::build);

    public Sql(Builder builder) {
        super(builder);
        this.features = ModelTypeHelper.unmodifiableNonNull(builder.features, "features");
        this.queries = ModelTypeHelper.unmodifiableNonNull(builder.queries, "queries");
    }

    public Sql(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, Integer> features() {
        return this.features;
    }

    public Map<String, Query> queries() {
        return this.queries;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("features");
        generator.writeStartObject();
        for (Map.Entry<String, Integer> entry : this.features.entrySet()) {
            generator.writeKey(entry.getKey());
            generator.write(entry.getValue().intValue());
        }
        generator.writeEnd();
        generator.writeKey("queries");
        generator.writeStartObject();
        for (Map.Entry<String, Object> entry : this.queries.entrySet()) {
            generator.writeKey(entry.getKey());
            ((Query)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupSqlDeserializer(DelegatingDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::features, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "features", new String[0]);
        op.add(Builder::queries, JsonpDeserializer.stringMapDeserializer(Query._DESERIALIZER), "queries", new String[0]);
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Sql> {
        private Map<String, Integer> features;
        private Map<String, Query> queries;

        public Builder features(Map<String, Integer> value) {
            this.features = value;
            return this;
        }

        public Builder putFeatures(String key, Integer value) {
            if (this.features == null) {
                this.features = new HashMap<String, Integer>();
            }
            this.features.put(key, value);
            return this;
        }

        public Builder queries(Map<String, Query> value) {
            this.queries = value;
            return this;
        }

        public Builder putQueries(String key, Query value) {
            if (this.queries == null) {
                this.queries = new HashMap<String, Query>();
            }
            this.queries.put(key, value);
            return this;
        }

        public Builder queries(String key, Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.queries(Collections.singletonMap(key, fn.apply(new Query.Builder()).build()));
        }

        public Builder putQueries(String key, Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.putQueries(key, fn.apply(new Query.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Sql build() {
            return new Sql(this);
        }
    }
}

