/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RoleMapping
implements JsonpSerializable {
    private final int enabled;
    private final int size;
    public static final JsonpDeserializer<RoleMapping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RoleMapping::setupRoleMappingDeserializer, Builder::build);

    public RoleMapping(Builder builder) {
        this.enabled = Objects.requireNonNull(builder.enabled, "enabled");
        this.size = Objects.requireNonNull(builder.size, "size");
    }

    public RoleMapping(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int enabled() {
        return this.enabled;
    }

    public int size() {
        return this.size;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("enabled");
        generator.write(this.enabled);
        generator.writeKey("size");
        generator.write(this.size);
    }

    protected static void setupRoleMappingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::enabled, JsonpDeserializer.integerDeserializer(), "enabled", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RoleMapping> {
        private Integer enabled;
        private Integer size;

        public Builder enabled(int value) {
            this.enabled = value;
            return this;
        }

        public Builder size(int value) {
            this.size = value;
            return this;
        }

        @Override
        public RoleMapping build() {
            return new RoleMapping(this);
        }
    }
}

