/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class FrozenIndices
extends Base {
    private final long indicesCount;
    public static final JsonpDeserializer<FrozenIndices> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FrozenIndices::setupFrozenIndicesDeserializer, Builder::build);

    public FrozenIndices(Builder builder) {
        super(builder);
        this.indicesCount = Objects.requireNonNull(builder.indicesCount, "indices_count");
    }

    public FrozenIndices(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long indicesCount() {
        return this.indicesCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("indices_count");
        generator.write(this.indicesCount);
    }

    protected static void setupFrozenIndicesDeserializer(DelegatingDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::indicesCount, JsonpDeserializer.longDeserializer(), "indices_count", new String[0]);
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<FrozenIndices> {
        private Long indicesCount;

        public Builder indicesCount(long value) {
            this.indicesCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FrozenIndices build() {
            return new FrozenIndices(this);
        }
    }
}

