/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class EqlFeaturesSequences
implements JsonpSerializable {
    private final Number sequenceQueriesThree;
    private final Number sequenceQueriesFour;
    private final Number sequenceQueriesTwo;
    private final Number sequenceUntil;
    private final Number sequenceQueriesFiveOrMore;
    private final Number sequenceMaxspan;
    public static final JsonpDeserializer<EqlFeaturesSequences> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EqlFeaturesSequences::setupEqlFeaturesSequencesDeserializer, Builder::build);

    public EqlFeaturesSequences(Builder builder) {
        this.sequenceQueriesThree = Objects.requireNonNull(builder.sequenceQueriesThree, "sequence_queries_three");
        this.sequenceQueriesFour = Objects.requireNonNull(builder.sequenceQueriesFour, "sequence_queries_four");
        this.sequenceQueriesTwo = Objects.requireNonNull(builder.sequenceQueriesTwo, "sequence_queries_two");
        this.sequenceUntil = Objects.requireNonNull(builder.sequenceUntil, "sequence_until");
        this.sequenceQueriesFiveOrMore = Objects.requireNonNull(builder.sequenceQueriesFiveOrMore, "sequence_queries_five_or_more");
        this.sequenceMaxspan = Objects.requireNonNull(builder.sequenceMaxspan, "sequence_maxspan");
    }

    public EqlFeaturesSequences(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Number sequenceQueriesThree() {
        return this.sequenceQueriesThree;
    }

    public Number sequenceQueriesFour() {
        return this.sequenceQueriesFour;
    }

    public Number sequenceQueriesTwo() {
        return this.sequenceQueriesTwo;
    }

    public Number sequenceUntil() {
        return this.sequenceUntil;
    }

    public Number sequenceQueriesFiveOrMore() {
        return this.sequenceQueriesFiveOrMore;
    }

    public Number sequenceMaxspan() {
        return this.sequenceMaxspan;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("sequence_queries_three");
        generator.write(this.sequenceQueriesThree.doubleValue());
        generator.writeKey("sequence_queries_four");
        generator.write(this.sequenceQueriesFour.doubleValue());
        generator.writeKey("sequence_queries_two");
        generator.write(this.sequenceQueriesTwo.doubleValue());
        generator.writeKey("sequence_until");
        generator.write(this.sequenceUntil.doubleValue());
        generator.writeKey("sequence_queries_five_or_more");
        generator.write(this.sequenceQueriesFiveOrMore.doubleValue());
        generator.writeKey("sequence_maxspan");
        generator.write(this.sequenceMaxspan.doubleValue());
    }

    protected static void setupEqlFeaturesSequencesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::sequenceQueriesThree, JsonpDeserializer.numberDeserializer(), "sequence_queries_three", new String[0]);
        op.add(Builder::sequenceQueriesFour, JsonpDeserializer.numberDeserializer(), "sequence_queries_four", new String[0]);
        op.add(Builder::sequenceQueriesTwo, JsonpDeserializer.numberDeserializer(), "sequence_queries_two", new String[0]);
        op.add(Builder::sequenceUntil, JsonpDeserializer.numberDeserializer(), "sequence_until", new String[0]);
        op.add(Builder::sequenceQueriesFiveOrMore, JsonpDeserializer.numberDeserializer(), "sequence_queries_five_or_more", new String[0]);
        op.add(Builder::sequenceMaxspan, JsonpDeserializer.numberDeserializer(), "sequence_maxspan", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<EqlFeaturesSequences> {
        private Number sequenceQueriesThree;
        private Number sequenceQueriesFour;
        private Number sequenceQueriesTwo;
        private Number sequenceUntil;
        private Number sequenceQueriesFiveOrMore;
        private Number sequenceMaxspan;

        public Builder sequenceQueriesThree(Number value) {
            this.sequenceQueriesThree = value;
            return this;
        }

        public Builder sequenceQueriesFour(Number value) {
            this.sequenceQueriesFour = value;
            return this;
        }

        public Builder sequenceQueriesTwo(Number value) {
            this.sequenceQueriesTwo = value;
            return this;
        }

        public Builder sequenceUntil(Number value) {
            this.sequenceUntil = value;
            return this;
        }

        public Builder sequenceQueriesFiveOrMore(Number value) {
            this.sequenceQueriesFiveOrMore = value;
            return this;
        }

        public Builder sequenceMaxspan(Number value) {
            this.sequenceMaxspan = value;
            return this;
        }

        @Override
        public EqlFeaturesSequences build() {
            return new EqlFeaturesSequences(this);
        }
    }
}

