/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;

@JsonpDeserializable
public class Counter
implements JsonpSerializable {
    private final long active;
    private final long total;
    public static final JsonpDeserializer<Counter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Counter::setupCounterDeserializer, Builder::build);

    public Counter(AbstractBuilder<?> builder) {
        this.active = Objects.requireNonNull(((AbstractBuilder)builder).active, "active");
        this.total = Objects.requireNonNull(((AbstractBuilder)builder).total, "total");
    }

    public long active() {
        return this.active;
    }

    public long total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active");
        generator.write(this.active);
        generator.writeKey("total");
        generator.write(this.total);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupCounterDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::active, JsonpDeserializer.longDeserializer(), "active", new String[0]);
        op.add(AbstractBuilder::total, JsonpDeserializer.longDeserializer(), "total", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        private Long active;
        private Long total;

        protected AbstractBuilder() {
        }

        public BuilderT active(long value) {
            this.active = value;
            return this.self();
        }

        public BuilderT total(long value) {
            this.total = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<Counter> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Counter build() {
            return new Counter(this);
        }
    }
}

