/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher.execute_watch;

import co.elastic.clients.elasticsearch.watcher.Condition;
import co.elastic.clients.elasticsearch.watcher.ExecutionResult;
import co.elastic.clients.elasticsearch.watcher.ExecutionStatus;
import co.elastic.clients.elasticsearch.watcher.Input;
import co.elastic.clients.elasticsearch.watcher.TriggerEventResult;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class WatchRecord
implements JsonpSerializable {
    private final Condition condition;
    private final Input input;
    private final List<String> messages;
    private final Map<String, JsonData> metadata;
    private final String node;
    private final ExecutionResult result;
    private final ExecutionStatus state;
    private final TriggerEventResult triggerEvent;
    private final String user;
    private final String watchId;
    public static final JsonpDeserializer<WatchRecord> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WatchRecord::setupWatchRecordDeserializer, Builder::build);

    public WatchRecord(Builder builder) {
        this.condition = Objects.requireNonNull(builder.condition, "condition");
        this.input = Objects.requireNonNull(builder.input, "input");
        this.messages = ModelTypeHelper.unmodifiableNonNull(builder.messages, "messages");
        this.metadata = ModelTypeHelper.unmodifiableNonNull(builder.metadata, "metadata");
        this.node = Objects.requireNonNull(builder.node, "node");
        this.result = Objects.requireNonNull(builder.result, "result");
        this.state = Objects.requireNonNull(builder.state, "state");
        this.triggerEvent = Objects.requireNonNull(builder.triggerEvent, "trigger_event");
        this.user = Objects.requireNonNull(builder.user, "user");
        this.watchId = Objects.requireNonNull(builder.watchId, "watch_id");
    }

    public WatchRecord(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Condition condition() {
        return this.condition;
    }

    public Input input() {
        return this.input;
    }

    public List<String> messages() {
        return this.messages;
    }

    public Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public String node() {
        return this.node;
    }

    public ExecutionResult result() {
        return this.result;
    }

    public ExecutionStatus state() {
        return this.state;
    }

    public TriggerEventResult triggerEvent() {
        return this.triggerEvent;
    }

    public String user() {
        return this.user;
    }

    public String watchId() {
        return this.watchId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("condition");
        this.condition.serialize(generator, mapper);
        generator.writeKey("input");
        this.input.serialize(generator, mapper);
        generator.writeKey("messages");
        generator.writeStartArray();
        for (String string : this.messages) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("metadata");
        generator.writeStartObject();
        for (Map.Entry entry : this.metadata.entrySet()) {
            generator.writeKey((String)entry.getKey());
            ((JsonData)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("node");
        generator.write(this.node);
        generator.writeKey("result");
        this.result.serialize(generator, mapper);
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        generator.writeKey("trigger_event");
        this.triggerEvent.serialize(generator, mapper);
        generator.writeKey("user");
        generator.write(this.user);
        generator.writeKey("watch_id");
        generator.write(this.watchId);
    }

    protected static void setupWatchRecordDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::condition, Condition._DESERIALIZER, "condition", new String[0]);
        op.add(Builder::input, Input._DESERIALIZER, "input", new String[0]);
        op.add(Builder::messages, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "messages", new String[0]);
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata", new String[0]);
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node", new String[0]);
        op.add(Builder::result, ExecutionResult._DESERIALIZER, "result", new String[0]);
        op.add(Builder::state, ExecutionStatus._DESERIALIZER, "state", new String[0]);
        op.add(Builder::triggerEvent, TriggerEventResult._DESERIALIZER, "trigger_event", new String[0]);
        op.add(Builder::user, JsonpDeserializer.stringDeserializer(), "user", new String[0]);
        op.add(Builder::watchId, JsonpDeserializer.stringDeserializer(), "watch_id", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<WatchRecord> {
        private Condition condition;
        private Input input;
        private List<String> messages;
        private Map<String, JsonData> metadata;
        private String node;
        private ExecutionResult result;
        private ExecutionStatus state;
        private TriggerEventResult triggerEvent;
        private String user;
        private String watchId;

        public Builder condition(Condition value) {
            this.condition = value;
            return this;
        }

        public Builder condition(Function<Condition.Builder, ObjectBuilder<Condition>> fn) {
            return this.condition(fn.apply(new Condition.Builder()).build());
        }

        public Builder input(Input value) {
            this.input = value;
            return this;
        }

        public Builder input(Function<Input.Builder, ObjectBuilder<Input>> fn) {
            return this.input(fn.apply(new Input.Builder()).build());
        }

        public Builder messages(List<String> value) {
            this.messages = value;
            return this;
        }

        public Builder messages(String ... value) {
            this.messages = Arrays.asList(value);
            return this;
        }

        public Builder addMessages(String value) {
            if (this.messages == null) {
                this.messages = new ArrayList<String>();
            }
            this.messages.add(value);
            return this;
        }

        public Builder metadata(Map<String, JsonData> value) {
            this.metadata = value;
            return this;
        }

        public Builder putMetadata(String key, JsonData value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, JsonData>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder node(String value) {
            this.node = value;
            return this;
        }

        public Builder result(ExecutionResult value) {
            this.result = value;
            return this;
        }

        public Builder result(Function<ExecutionResult.Builder, ObjectBuilder<ExecutionResult>> fn) {
            return this.result(fn.apply(new ExecutionResult.Builder()).build());
        }

        public Builder state(ExecutionStatus value) {
            this.state = value;
            return this;
        }

        public Builder triggerEvent(TriggerEventResult value) {
            this.triggerEvent = value;
            return this;
        }

        public Builder triggerEvent(Function<TriggerEventResult.Builder, ObjectBuilder<TriggerEventResult>> fn) {
            return this.triggerEvent(fn.apply(new TriggerEventResult.Builder()).build());
        }

        public Builder user(String value) {
            this.user = value;
            return this;
        }

        public Builder watchId(String value) {
            this.watchId = value;
            return this;
        }

        @Override
        public WatchRecord build() {
            return new WatchRecord(this);
        }
    }
}

