/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.Month;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class TimeOfYear
implements JsonpSerializable {
    private final List<String> at;
    private final List<Month> int_;
    private final List<Integer> on;
    public static final JsonpDeserializer<TimeOfYear> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TimeOfYear::setupTimeOfYearDeserializer, Builder::build);

    public TimeOfYear(Builder builder) {
        this.at = ModelTypeHelper.unmodifiableNonNull(builder.at, "at");
        this.int_ = ModelTypeHelper.unmodifiableNonNull(builder.int_, "int");
        this.on = ModelTypeHelper.unmodifiableNonNull(builder.on, "on");
    }

    public TimeOfYear(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> at() {
        return this.at;
    }

    public List<Month> int_() {
        return this.int_;
    }

    public List<Integer> on() {
        return this.on;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("at");
        generator.writeStartArray();
        for (String string : this.at) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("int");
        generator.writeStartArray();
        for (Month month : this.int_) {
            month.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("on");
        generator.writeStartArray();
        for (Integer n : this.on) {
            generator.write(n.intValue());
        }
        generator.writeEnd();
    }

    protected static void setupTimeOfYearDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::at, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "at", new String[0]);
        op.add(Builder::int_, JsonpDeserializer.arrayDeserializer(Month._DESERIALIZER), "int", new String[0]);
        op.add(Builder::on, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.integerDeserializer()), "on", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TimeOfYear> {
        private List<String> at;
        private List<Month> int_;
        private List<Integer> on;

        public Builder at(List<String> value) {
            this.at = value;
            return this;
        }

        public Builder at(String ... value) {
            this.at = Arrays.asList(value);
            return this;
        }

        public Builder addAt(String value) {
            if (this.at == null) {
                this.at = new ArrayList<String>();
            }
            this.at.add(value);
            return this;
        }

        public Builder int_(List<Month> value) {
            this.int_ = value;
            return this;
        }

        public Builder int_(Month ... value) {
            this.int_ = Arrays.asList(value);
            return this;
        }

        public Builder addInt(Month value) {
            if (this.int_ == null) {
                this.int_ = new ArrayList<Month>();
            }
            this.int_.add(value);
            return this;
        }

        public Builder on(List<Integer> value) {
            this.on = value;
            return this;
        }

        public Builder on(Integer ... value) {
            this.on = Arrays.asList(value);
            return this;
        }

        public Builder addOn(Integer value) {
            if (this.on == null) {
                this.on = new ArrayList<Integer>();
            }
            this.on.add(value);
            return this;
        }

        @Override
        public TimeOfYear build() {
            return new TimeOfYear(this);
        }
    }
}

