/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.PagerDutyContext;
import co.elastic.clients.elasticsearch.watcher.PagerDutyEventType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PagerDutyEvent
implements JsonpSerializable {
    private final String account;
    private final boolean attachPayload;
    private final String client;
    private final String clientUrl;
    private final List<PagerDutyContext> context;
    private final String description;
    private final PagerDutyEventType eventType;
    private final String incidentKey;
    public static final JsonpDeserializer<PagerDutyEvent> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PagerDutyEvent::setupPagerDutyEventDeserializer, Builder::build);

    public PagerDutyEvent(Builder builder) {
        this.account = Objects.requireNonNull(builder.account, "account");
        this.attachPayload = Objects.requireNonNull(builder.attachPayload, "attach_payload");
        this.client = Objects.requireNonNull(builder.client, "client");
        this.clientUrl = Objects.requireNonNull(builder.clientUrl, "client_url");
        this.context = ModelTypeHelper.unmodifiableNonNull(builder.context, "context");
        this.description = Objects.requireNonNull(builder.description, "description");
        this.eventType = Objects.requireNonNull(builder.eventType, "event_type");
        this.incidentKey = Objects.requireNonNull(builder.incidentKey, "incident_key");
    }

    public PagerDutyEvent(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String account() {
        return this.account;
    }

    public boolean attachPayload() {
        return this.attachPayload;
    }

    public String client() {
        return this.client;
    }

    public String clientUrl() {
        return this.clientUrl;
    }

    public List<PagerDutyContext> context() {
        return this.context;
    }

    public String description() {
        return this.description;
    }

    public PagerDutyEventType eventType() {
        return this.eventType;
    }

    public String incidentKey() {
        return this.incidentKey;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("account");
        generator.write(this.account);
        generator.writeKey("attach_payload");
        generator.write(this.attachPayload);
        generator.writeKey("client");
        generator.write(this.client);
        generator.writeKey("client_url");
        generator.write(this.clientUrl);
        generator.writeKey("context");
        generator.writeStartArray();
        for (PagerDutyContext item0 : this.context) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("event_type");
        this.eventType.serialize(generator, mapper);
        generator.writeKey("incident_key");
        generator.write(this.incidentKey);
    }

    protected static void setupPagerDutyEventDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::account, JsonpDeserializer.stringDeserializer(), "account", new String[0]);
        op.add(Builder::attachPayload, JsonpDeserializer.booleanDeserializer(), "attach_payload", new String[0]);
        op.add(Builder::client, JsonpDeserializer.stringDeserializer(), "client", new String[0]);
        op.add(Builder::clientUrl, JsonpDeserializer.stringDeserializer(), "client_url", new String[0]);
        op.add(Builder::context, JsonpDeserializer.arrayDeserializer(PagerDutyContext._DESERIALIZER), "context", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::eventType, PagerDutyEventType._DESERIALIZER, "event_type", new String[0]);
        op.add(Builder::incidentKey, JsonpDeserializer.stringDeserializer(), "incident_key", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PagerDutyEvent> {
        private String account;
        private Boolean attachPayload;
        private String client;
        private String clientUrl;
        private List<PagerDutyContext> context;
        private String description;
        private PagerDutyEventType eventType;
        private String incidentKey;

        public Builder account(String value) {
            this.account = value;
            return this;
        }

        public Builder attachPayload(boolean value) {
            this.attachPayload = value;
            return this;
        }

        public Builder client(String value) {
            this.client = value;
            return this;
        }

        public Builder clientUrl(String value) {
            this.clientUrl = value;
            return this;
        }

        public Builder context(List<PagerDutyContext> value) {
            this.context = value;
            return this;
        }

        public Builder context(PagerDutyContext ... value) {
            this.context = Arrays.asList(value);
            return this;
        }

        public Builder addContext(PagerDutyContext value) {
            if (this.context == null) {
                this.context = new ArrayList<PagerDutyContext>();
            }
            this.context.add(value);
            return this;
        }

        public Builder context(Function<PagerDutyContext.Builder, ObjectBuilder<PagerDutyContext>> fn) {
            return this.context(fn.apply(new PagerDutyContext.Builder()).build());
        }

        public Builder addContext(Function<PagerDutyContext.Builder, ObjectBuilder<PagerDutyContext>> fn) {
            return this.addContext(fn.apply(new PagerDutyContext.Builder()).build());
        }

        public Builder description(String value) {
            this.description = value;
            return this;
        }

        public Builder eventType(PagerDutyEventType value) {
            this.eventType = value;
            return this;
        }

        public Builder incidentKey(String value) {
            this.incidentKey = value;
            return this;
        }

        @Override
        public PagerDutyEvent build() {
            return new PagerDutyEvent(this);
        }
    }
}

