/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.Watch;
import co.elastic.clients.elasticsearch.watcher.WatchStatus;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GetWatchResponse
implements JsonpSerializable {
    private final boolean found;
    private final String id;
    @Nullable
    private final WatchStatus status;
    @Nullable
    private final Watch watch;
    @Nullable
    private final Integer primaryTerm;
    @Nullable
    private final Integer seqNo;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<GetWatchResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetWatchResponse::setupGetWatchResponseDeserializer, Builder::build);

    public GetWatchResponse(Builder builder) {
        this.found = Objects.requireNonNull(builder.found, "found");
        this.id = Objects.requireNonNull(builder.id, "_id");
        this.status = builder.status;
        this.watch = builder.watch;
        this.primaryTerm = builder.primaryTerm;
        this.seqNo = builder.seqNo;
        this.version = builder.version;
    }

    public GetWatchResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean found() {
        return this.found;
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public WatchStatus status() {
        return this.status;
    }

    @Nullable
    public Watch watch() {
        return this.watch;
    }

    @Nullable
    public Integer primaryTerm() {
        return this.primaryTerm;
    }

    @Nullable
    public Integer seqNo() {
        return this.seqNo;
    }

    @Nullable
    public Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("found");
        generator.write(this.found);
        generator.writeKey("_id");
        generator.write(this.id);
        if (this.status != null) {
            generator.writeKey("status");
            this.status.serialize(generator, mapper);
        }
        if (this.watch != null) {
            generator.writeKey("watch");
            this.watch.serialize(generator, mapper);
        }
        if (this.primaryTerm != null) {
            generator.writeKey("_primary_term");
            generator.write(this.primaryTerm.intValue());
        }
        if (this.seqNo != null) {
            generator.writeKey("_seq_no");
            generator.write(this.seqNo.intValue());
        }
        if (this.version != null) {
            generator.writeKey("_version");
            generator.write(this.version.longValue());
        }
    }

    protected static void setupGetWatchResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::found, JsonpDeserializer.booleanDeserializer(), "found", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(Builder::status, WatchStatus._DESERIALIZER, "status", new String[0]);
        op.add(Builder::watch, Watch._DESERIALIZER, "watch", new String[0]);
        op.add(Builder::primaryTerm, JsonpDeserializer.integerDeserializer(), "_primary_term", new String[0]);
        op.add(Builder::seqNo, JsonpDeserializer.integerDeserializer(), "_seq_no", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "_version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetWatchResponse> {
        private Boolean found;
        private String id;
        @Nullable
        private WatchStatus status;
        @Nullable
        private Watch watch;
        @Nullable
        private Integer primaryTerm;
        @Nullable
        private Integer seqNo;
        @Nullable
        private Long version;

        public Builder found(boolean value) {
            this.found = value;
            return this;
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder status(@Nullable WatchStatus value) {
            this.status = value;
            return this;
        }

        public Builder status(Function<WatchStatus.Builder, ObjectBuilder<WatchStatus>> fn) {
            return this.status(fn.apply(new WatchStatus.Builder()).build());
        }

        public Builder watch(@Nullable Watch value) {
            this.watch = value;
            return this;
        }

        public Builder watch(Function<Watch.Builder, ObjectBuilder<Watch>> fn) {
            return this.watch(fn.apply(new Watch.Builder()).build());
        }

        public Builder primaryTerm(@Nullable Integer value) {
            this.primaryTerm = value;
            return this;
        }

        public Builder seqNo(@Nullable Integer value) {
            this.seqNo = value;
            return this;
        }

        public Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        public GetWatchResponse build() {
            return new GetWatchResponse(this);
        }
    }
}

