/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ExecutionThreadPool
implements JsonpSerializable {
    private final long maxSize;
    private final long queueSize;
    public static final JsonpDeserializer<ExecutionThreadPool> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExecutionThreadPool::setupExecutionThreadPoolDeserializer, Builder::build);

    public ExecutionThreadPool(Builder builder) {
        this.maxSize = Objects.requireNonNull(builder.maxSize, "max_size");
        this.queueSize = Objects.requireNonNull(builder.queueSize, "queue_size");
    }

    public ExecutionThreadPool(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long maxSize() {
        return this.maxSize;
    }

    public long queueSize() {
        return this.queueSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max_size");
        generator.write(this.maxSize);
        generator.writeKey("queue_size");
        generator.write(this.queueSize);
    }

    protected static void setupExecutionThreadPoolDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::maxSize, JsonpDeserializer.longDeserializer(), "max_size", new String[0]);
        op.add(Builder::queueSize, JsonpDeserializer.longDeserializer(), "queue_size", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ExecutionThreadPool> {
        private Long maxSize;
        private Long queueSize;

        public Builder maxSize(long value) {
            this.maxSize = value;
            return this;
        }

        public Builder queueSize(long value) {
            this.queueSize = value;
            return this;
        }

        @Override
        public ExecutionThreadPool build() {
            return new ExecutionThreadPool(this);
        }
    }
}

