/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ActionStatusOptions;
import co.elastic.clients.elasticsearch.watcher.InputType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ExecutionResultInput
implements JsonpSerializable {
    private final Map<String, JsonData> payload;
    private final ActionStatusOptions status;
    private final InputType type;
    public static final JsonpDeserializer<ExecutionResultInput> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExecutionResultInput::setupExecutionResultInputDeserializer, Builder::build);

    public ExecutionResultInput(Builder builder) {
        this.payload = ModelTypeHelper.unmodifiableNonNull(builder.payload, "payload");
        this.status = Objects.requireNonNull(builder.status, "status");
        this.type = Objects.requireNonNull(builder.type, "type");
    }

    public ExecutionResultInput(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, JsonData> payload() {
        return this.payload;
    }

    public ActionStatusOptions status() {
        return this.status;
    }

    public InputType type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("payload");
        generator.writeStartObject();
        for (Map.Entry<String, JsonData> item0 : this.payload.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
    }

    protected static void setupExecutionResultInputDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::payload, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "payload", new String[0]);
        op.add(Builder::status, ActionStatusOptions._DESERIALIZER, "status", new String[0]);
        op.add(Builder::type, InputType._DESERIALIZER, "type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ExecutionResultInput> {
        private Map<String, JsonData> payload;
        private ActionStatusOptions status;
        private InputType type;

        public Builder payload(Map<String, JsonData> value) {
            this.payload = value;
            return this;
        }

        public Builder putPayload(String key, JsonData value) {
            if (this.payload == null) {
                this.payload = new HashMap<String, JsonData>();
            }
            this.payload.put(key, value);
            return this;
        }

        public Builder status(ActionStatusOptions value) {
            this.status = value;
            return this;
        }

        public Builder type(InputType value) {
            this.type = value;
            return this;
        }

        @Override
        public ExecutionResultInput build() {
            return new ExecutionResultInput(this);
        }
    }
}

