/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ActionStatusOptions;
import co.elastic.clients.elasticsearch.watcher.ActionType;
import co.elastic.clients.elasticsearch.watcher.EmailResult;
import co.elastic.clients.elasticsearch.watcher.IndexResult;
import co.elastic.clients.elasticsearch.watcher.LoggingResult;
import co.elastic.clients.elasticsearch.watcher.PagerDutyResult;
import co.elastic.clients.elasticsearch.watcher.SlackResult;
import co.elastic.clients.elasticsearch.watcher.WebhookResult;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ExecutionResultAction
implements JsonpSerializable {
    @Nullable
    private final EmailResult email;
    private final String id;
    @Nullable
    private final IndexResult index;
    @Nullable
    private final LoggingResult logging;
    @Nullable
    private final PagerDutyResult pagerduty;
    @Nullable
    private final String reason;
    @Nullable
    private final SlackResult slack;
    private final ActionStatusOptions status;
    private final ActionType type;
    @Nullable
    private final WebhookResult webhook;
    public static final JsonpDeserializer<ExecutionResultAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExecutionResultAction::setupExecutionResultActionDeserializer, Builder::build);

    public ExecutionResultAction(Builder builder) {
        this.email = builder.email;
        this.id = Objects.requireNonNull(builder.id, "id");
        this.index = builder.index;
        this.logging = builder.logging;
        this.pagerduty = builder.pagerduty;
        this.reason = builder.reason;
        this.slack = builder.slack;
        this.status = Objects.requireNonNull(builder.status, "status");
        this.type = Objects.requireNonNull(builder.type, "type");
        this.webhook = builder.webhook;
    }

    public ExecutionResultAction(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public EmailResult email() {
        return this.email;
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public IndexResult index() {
        return this.index;
    }

    @Nullable
    public LoggingResult logging() {
        return this.logging;
    }

    @Nullable
    public PagerDutyResult pagerduty() {
        return this.pagerduty;
    }

    @Nullable
    public String reason() {
        return this.reason;
    }

    @Nullable
    public SlackResult slack() {
        return this.slack;
    }

    public ActionStatusOptions status() {
        return this.status;
    }

    public ActionType type() {
        return this.type;
    }

    @Nullable
    public WebhookResult webhook() {
        return this.webhook;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.email != null) {
            generator.writeKey("email");
            this.email.serialize(generator, mapper);
        }
        generator.writeKey("id");
        generator.write(this.id);
        if (this.index != null) {
            generator.writeKey("index");
            this.index.serialize(generator, mapper);
        }
        if (this.logging != null) {
            generator.writeKey("logging");
            this.logging.serialize(generator, mapper);
        }
        if (this.pagerduty != null) {
            generator.writeKey("pagerduty");
            this.pagerduty.serialize(generator, mapper);
        }
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
        if (this.slack != null) {
            generator.writeKey("slack");
            this.slack.serialize(generator, mapper);
        }
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        if (this.webhook != null) {
            generator.writeKey("webhook");
            this.webhook.serialize(generator, mapper);
        }
    }

    protected static void setupExecutionResultActionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::email, EmailResult._DESERIALIZER, "email", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::index, IndexResult._DESERIALIZER, "index", new String[0]);
        op.add(Builder::logging, LoggingResult._DESERIALIZER, "logging", new String[0]);
        op.add(Builder::pagerduty, PagerDutyResult._DESERIALIZER, "pagerduty", new String[0]);
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason", new String[0]);
        op.add(Builder::slack, SlackResult._DESERIALIZER, "slack", new String[0]);
        op.add(Builder::status, ActionStatusOptions._DESERIALIZER, "status", new String[0]);
        op.add(Builder::type, ActionType._DESERIALIZER, "type", new String[0]);
        op.add(Builder::webhook, WebhookResult._DESERIALIZER, "webhook", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ExecutionResultAction> {
        @Nullable
        private EmailResult email;
        private String id;
        @Nullable
        private IndexResult index;
        @Nullable
        private LoggingResult logging;
        @Nullable
        private PagerDutyResult pagerduty;
        @Nullable
        private String reason;
        @Nullable
        private SlackResult slack;
        private ActionStatusOptions status;
        private ActionType type;
        @Nullable
        private WebhookResult webhook;

        public Builder email(@Nullable EmailResult value) {
            this.email = value;
            return this;
        }

        public Builder email(Function<EmailResult.Builder, ObjectBuilder<EmailResult>> fn) {
            return this.email(fn.apply(new EmailResult.Builder()).build());
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder index(@Nullable IndexResult value) {
            this.index = value;
            return this;
        }

        public Builder index(Function<IndexResult.Builder, ObjectBuilder<IndexResult>> fn) {
            return this.index(fn.apply(new IndexResult.Builder()).build());
        }

        public Builder logging(@Nullable LoggingResult value) {
            this.logging = value;
            return this;
        }

        public Builder logging(Function<LoggingResult.Builder, ObjectBuilder<LoggingResult>> fn) {
            return this.logging(fn.apply(new LoggingResult.Builder()).build());
        }

        public Builder pagerduty(@Nullable PagerDutyResult value) {
            this.pagerduty = value;
            return this;
        }

        public Builder pagerduty(Function<PagerDutyResult.Builder, ObjectBuilder<PagerDutyResult>> fn) {
            return this.pagerduty(fn.apply(new PagerDutyResult.Builder()).build());
        }

        public Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        public Builder slack(@Nullable SlackResult value) {
            this.slack = value;
            return this;
        }

        public Builder slack(Function<SlackResult.Builder, ObjectBuilder<SlackResult>> fn) {
            return this.slack(fn.apply(new SlackResult.Builder()).build());
        }

        public Builder status(ActionStatusOptions value) {
            this.status = value;
            return this;
        }

        public Builder type(ActionType value) {
            this.type = value;
            return this;
        }

        public Builder webhook(@Nullable WebhookResult value) {
            this.webhook = value;
            return this;
        }

        public Builder webhook(Function<WebhookResult.Builder, ObjectBuilder<WebhookResult>> fn) {
            return this.webhook(fn.apply(new WebhookResult.Builder()).build());
        }

        @Override
        public ExecutionResultAction build() {
            return new ExecutionResultAction(this);
        }
    }
}

