/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.transform.GetTransformResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetTransformRequest
extends RequestBase {
    @Nullable
    private final String transformId;
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    @Nullable
    private final Boolean excludeGenerated;
    public static final Endpoint<GetTransformRequest, GetTransformResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetTransformRequest, GetTransformResponse>(request -> "GET", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (request.transformId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId, buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.excludeGenerated != null) {
            params.put("exclude_generated", String.valueOf(request.excludeGenerated));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetTransformResponse._DESERIALIZER);

    public GetTransformRequest(Builder builder) {
        this.transformId = builder.transformId;
        this.allowNoMatch = builder.allowNoMatch;
        this.from = builder.from;
        this.size = builder.size;
        this.excludeGenerated = builder.excludeGenerated;
    }

    public GetTransformRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String transformId() {
        return this.transformId;
    }

    @Nullable
    public Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public Boolean excludeGenerated() {
        return this.excludeGenerated;
    }

    public static class Builder
    implements ObjectBuilder<GetTransformRequest> {
        @Nullable
        private String transformId;
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Integer from;
        @Nullable
        private Integer size;
        @Nullable
        private Boolean excludeGenerated;

        public Builder transformId(@Nullable String value) {
            this.transformId = value;
            return this;
        }

        public Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder excludeGenerated(@Nullable Boolean value) {
            this.excludeGenerated = value;
            return this;
        }

        @Override
        public GetTransformRequest build() {
            return new GetTransformRequest(this);
        }
    }
}

