/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.transform.DeleteTransformResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class DeleteTransformRequest
extends RequestBase {
    private final String transformId;
    @Nullable
    private final Boolean force;
    public static final Endpoint<DeleteTransformRequest, DeleteTransformResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteTransformRequest, DeleteTransformResponse>(request -> "DELETE", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.force != null) {
            params.put("force", String.valueOf(request.force));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteTransformResponse._DESERIALIZER);

    public DeleteTransformRequest(Builder builder) {
        this.transformId = Objects.requireNonNull(builder.transformId, "transform_id");
        this.force = builder.force;
    }

    public DeleteTransformRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String transformId() {
        return this.transformId;
    }

    @Nullable
    public Boolean force() {
        return this.force;
    }

    public static class Builder
    implements ObjectBuilder<DeleteTransformRequest> {
        private String transformId;
        @Nullable
        private Boolean force;

        public Builder transformId(String value) {
            this.transformId = value;
            return this;
        }

        public Builder force(@Nullable Boolean value) {
            this.force = value;
            return this;
        }

        @Override
        public DeleteTransformRequest build() {
            return new DeleteTransformRequest(this);
        }
    }
}

