/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot.get;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch.snapshot.SnapshotInfo;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SnapshotResponseItem
implements JsonpSerializable {
    private final String repository;
    @Nullable
    private final List<SnapshotInfo> snapshots;
    @Nullable
    private final ErrorCause error;
    public static final JsonpDeserializer<SnapshotResponseItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotResponseItem::setupSnapshotResponseItemDeserializer, Builder::build);

    public SnapshotResponseItem(Builder builder) {
        this.repository = Objects.requireNonNull(builder.repository, "repository");
        this.snapshots = ModelTypeHelper.unmodifiable(builder.snapshots);
        this.error = builder.error;
    }

    public SnapshotResponseItem(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String repository() {
        return this.repository;
    }

    @Nullable
    public List<SnapshotInfo> snapshots() {
        return this.snapshots;
    }

    @Nullable
    public ErrorCause error() {
        return this.error;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("repository");
        generator.write(this.repository);
        if (this.snapshots != null) {
            generator.writeKey("snapshots");
            generator.writeStartArray();
            for (SnapshotInfo item0 : this.snapshots) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.error != null) {
            generator.writeKey("error");
            this.error.serialize(generator, mapper);
        }
    }

    protected static void setupSnapshotResponseItemDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::repository, JsonpDeserializer.stringDeserializer(), "repository", new String[0]);
        op.add(Builder::snapshots, JsonpDeserializer.arrayDeserializer(SnapshotInfo._DESERIALIZER), "snapshots", new String[0]);
        op.add(Builder::error, ErrorCause._DESERIALIZER, "error", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SnapshotResponseItem> {
        private String repository;
        @Nullable
        private List<SnapshotInfo> snapshots;
        @Nullable
        private ErrorCause error;

        public Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public Builder snapshots(@Nullable List<SnapshotInfo> value) {
            this.snapshots = value;
            return this;
        }

        public Builder snapshots(SnapshotInfo ... value) {
            this.snapshots = Arrays.asList(value);
            return this;
        }

        public Builder addSnapshots(SnapshotInfo value) {
            if (this.snapshots == null) {
                this.snapshots = new ArrayList<SnapshotInfo>();
            }
            this.snapshots.add(value);
            return this;
        }

        public Builder snapshots(Function<SnapshotInfo.Builder, ObjectBuilder<SnapshotInfo>> fn) {
            return this.snapshots(fn.apply(new SnapshotInfo.Builder()).build());
        }

        public Builder addSnapshots(Function<SnapshotInfo.Builder, ObjectBuilder<SnapshotInfo>> fn) {
            return this.addSnapshots(fn.apply(new SnapshotInfo.Builder()).build());
        }

        public Builder error(@Nullable ErrorCause value) {
            this.error = value;
            return this;
        }

        public Builder error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        @Override
        public SnapshotResponseItem build() {
            return new SnapshotResponseItem(this);
        }
    }
}

