/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.verify_repository.CompactNodeInfo;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class VerifyRepositoryResponse
implements JsonpSerializable {
    private final Map<String, CompactNodeInfo> nodes;
    public static final JsonpDeserializer<VerifyRepositoryResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, VerifyRepositoryResponse::setupVerifyRepositoryResponseDeserializer, Builder::build);

    public VerifyRepositoryResponse(Builder builder) {
        this.nodes = ModelTypeHelper.unmodifiableNonNull(builder.nodes, "nodes");
    }

    public VerifyRepositoryResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, CompactNodeInfo> nodes() {
        return this.nodes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("nodes");
        generator.writeStartObject();
        for (Map.Entry<String, CompactNodeInfo> item0 : this.nodes.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupVerifyRepositoryResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(CompactNodeInfo._DESERIALIZER), "nodes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<VerifyRepositoryResponse> {
        private Map<String, CompactNodeInfo> nodes;

        public Builder nodes(Map<String, CompactNodeInfo> value) {
            this.nodes = value;
            return this;
        }

        public Builder putNodes(String key, CompactNodeInfo value) {
            if (this.nodes == null) {
                this.nodes = new HashMap<String, CompactNodeInfo>();
            }
            this.nodes.put(key, value);
            return this;
        }

        public Builder nodes(String key, Function<CompactNodeInfo.Builder, ObjectBuilder<CompactNodeInfo>> fn) {
            return this.nodes(Collections.singletonMap(key, fn.apply(new CompactNodeInfo.Builder()).build()));
        }

        public Builder putNodes(String key, Function<CompactNodeInfo.Builder, ObjectBuilder<CompactNodeInfo>> fn) {
            return this.putNodes(key, fn.apply(new CompactNodeInfo.Builder()).build());
        }

        @Override
        public VerifyRepositoryResponse build() {
            return new VerifyRepositoryResponse(this);
        }
    }
}

