/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.ShardsStats;
import co.elastic.clients.elasticsearch.snapshot.SnapshotIndexStats;
import co.elastic.clients.elasticsearch.snapshot.SnapshotStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Status
implements JsonpSerializable {
    private final boolean includeGlobalState;
    private final Map<String, SnapshotIndexStats> indices;
    private final String repository;
    private final ShardsStats shardsStats;
    private final String snapshot;
    private final String state;
    private final SnapshotStats stats;
    private final String uuid;
    public static final JsonpDeserializer<Status> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Status::setupStatusDeserializer, Builder::build);

    public Status(Builder builder) {
        this.includeGlobalState = Objects.requireNonNull(builder.includeGlobalState, "include_global_state");
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
        this.repository = Objects.requireNonNull(builder.repository, "repository");
        this.shardsStats = Objects.requireNonNull(builder.shardsStats, "shards_stats");
        this.snapshot = Objects.requireNonNull(builder.snapshot, "snapshot");
        this.state = Objects.requireNonNull(builder.state, "state");
        this.stats = Objects.requireNonNull(builder.stats, "stats");
        this.uuid = Objects.requireNonNull(builder.uuid, "uuid");
    }

    public Status(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public Map<String, SnapshotIndexStats> indices() {
        return this.indices;
    }

    public String repository() {
        return this.repository;
    }

    public ShardsStats shardsStats() {
        return this.shardsStats;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public String state() {
        return this.state;
    }

    public SnapshotStats stats() {
        return this.stats;
    }

    public String uuid() {
        return this.uuid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("include_global_state");
        generator.write(this.includeGlobalState);
        generator.writeKey("indices");
        generator.writeStartObject();
        for (Map.Entry<String, SnapshotIndexStats> item0 : this.indices.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("repository");
        generator.write(this.repository);
        generator.writeKey("shards_stats");
        this.shardsStats.serialize(generator, mapper);
        generator.writeKey("snapshot");
        generator.write(this.snapshot);
        generator.writeKey("state");
        generator.write(this.state);
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
        generator.writeKey("uuid");
        generator.write(this.uuid);
    }

    protected static void setupStatusDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::includeGlobalState, JsonpDeserializer.booleanDeserializer(), "include_global_state", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(SnapshotIndexStats._DESERIALIZER), "indices", new String[0]);
        op.add(Builder::repository, JsonpDeserializer.stringDeserializer(), "repository", new String[0]);
        op.add(Builder::shardsStats, ShardsStats._DESERIALIZER, "shards_stats", new String[0]);
        op.add(Builder::snapshot, JsonpDeserializer.stringDeserializer(), "snapshot", new String[0]);
        op.add(Builder::state, JsonpDeserializer.stringDeserializer(), "state", new String[0]);
        op.add(Builder::stats, SnapshotStats._DESERIALIZER, "stats", new String[0]);
        op.add(Builder::uuid, JsonpDeserializer.stringDeserializer(), "uuid", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Status> {
        private Boolean includeGlobalState;
        private Map<String, SnapshotIndexStats> indices;
        private String repository;
        private ShardsStats shardsStats;
        private String snapshot;
        private String state;
        private SnapshotStats stats;
        private String uuid;

        public Builder includeGlobalState(boolean value) {
            this.includeGlobalState = value;
            return this;
        }

        public Builder indices(Map<String, SnapshotIndexStats> value) {
            this.indices = value;
            return this;
        }

        public Builder putIndices(String key, SnapshotIndexStats value) {
            if (this.indices == null) {
                this.indices = new HashMap<String, SnapshotIndexStats>();
            }
            this.indices.put(key, value);
            return this;
        }

        public Builder indices(String key, Function<SnapshotIndexStats.Builder, ObjectBuilder<SnapshotIndexStats>> fn) {
            return this.indices(Collections.singletonMap(key, fn.apply(new SnapshotIndexStats.Builder()).build()));
        }

        public Builder putIndices(String key, Function<SnapshotIndexStats.Builder, ObjectBuilder<SnapshotIndexStats>> fn) {
            return this.putIndices(key, fn.apply(new SnapshotIndexStats.Builder()).build());
        }

        public Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public Builder shardsStats(ShardsStats value) {
            this.shardsStats = value;
            return this;
        }

        public Builder shardsStats(Function<ShardsStats.Builder, ObjectBuilder<ShardsStats>> fn) {
            return this.shardsStats(fn.apply(new ShardsStats.Builder()).build());
        }

        public Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        public Builder state(String value) {
            this.state = value;
            return this;
        }

        public Builder stats(SnapshotStats value) {
            this.stats = value;
            return this;
        }

        public Builder stats(Function<SnapshotStats.Builder, ObjectBuilder<SnapshotStats>> fn) {
            return this.stats(fn.apply(new SnapshotStats.Builder()).build());
        }

        public Builder uuid(String value) {
            this.uuid = value;
            return this;
        }

        @Override
        public Status build() {
            return new Status(this);
        }
    }
}

