/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.ShardsStatsStage;
import co.elastic.clients.elasticsearch.snapshot.ShardsStatsSummary;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SnapshotShardsStatus
implements JsonpSerializable {
    private final ShardsStatsStage stage;
    private final ShardsStatsSummary stats;
    public static final JsonpDeserializer<SnapshotShardsStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotShardsStatus::setupSnapshotShardsStatusDeserializer, Builder::build);

    public SnapshotShardsStatus(Builder builder) {
        this.stage = Objects.requireNonNull(builder.stage, "stage");
        this.stats = Objects.requireNonNull(builder.stats, "stats");
    }

    public SnapshotShardsStatus(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public ShardsStatsStage stage() {
        return this.stage;
    }

    public ShardsStatsSummary stats() {
        return this.stats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("stage");
        this.stage.serialize(generator, mapper);
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
    }

    protected static void setupSnapshotShardsStatusDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::stage, ShardsStatsStage._DESERIALIZER, "stage", new String[0]);
        op.add(Builder::stats, ShardsStatsSummary._DESERIALIZER, "stats", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SnapshotShardsStatus> {
        private ShardsStatsStage stage;
        private ShardsStatsSummary stats;

        public Builder stage(ShardsStatsStage value) {
            this.stage = value;
            return this;
        }

        public Builder stats(ShardsStatsSummary value) {
            this.stats = value;
            return this;
        }

        public Builder stats(Function<ShardsStatsSummary.Builder, ObjectBuilder<ShardsStatsSummary>> fn) {
            return this.stats(fn.apply(new ShardsStatsSummary.Builder()).build());
        }

        @Override
        public SnapshotShardsStatus build() {
            return new SnapshotShardsStatus(this);
        }
    }
}

