/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardsStats
implements JsonpSerializable {
    private final long done;
    private final long failed;
    private final long finalizing;
    private final long initializing;
    private final long started;
    private final long total;
    public static final JsonpDeserializer<ShardsStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardsStats::setupShardsStatsDeserializer, Builder::build);

    public ShardsStats(Builder builder) {
        this.done = Objects.requireNonNull(builder.done, "done");
        this.failed = Objects.requireNonNull(builder.failed, "failed");
        this.finalizing = Objects.requireNonNull(builder.finalizing, "finalizing");
        this.initializing = Objects.requireNonNull(builder.initializing, "initializing");
        this.started = Objects.requireNonNull(builder.started, "started");
        this.total = Objects.requireNonNull(builder.total, "total");
    }

    public ShardsStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long done() {
        return this.done;
    }

    public long failed() {
        return this.failed;
    }

    public long finalizing() {
        return this.finalizing;
    }

    public long initializing() {
        return this.initializing;
    }

    public long started() {
        return this.started;
    }

    public long total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("done");
        generator.write(this.done);
        generator.writeKey("failed");
        generator.write(this.failed);
        generator.writeKey("finalizing");
        generator.write(this.finalizing);
        generator.writeKey("initializing");
        generator.write(this.initializing);
        generator.writeKey("started");
        generator.write(this.started);
        generator.writeKey("total");
        generator.write(this.total);
    }

    protected static void setupShardsStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::done, JsonpDeserializer.longDeserializer(), "done", new String[0]);
        op.add(Builder::failed, JsonpDeserializer.longDeserializer(), "failed", new String[0]);
        op.add(Builder::finalizing, JsonpDeserializer.longDeserializer(), "finalizing", new String[0]);
        op.add(Builder::initializing, JsonpDeserializer.longDeserializer(), "initializing", new String[0]);
        op.add(Builder::started, JsonpDeserializer.longDeserializer(), "started", new String[0]);
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardsStats> {
        private Long done;
        private Long failed;
        private Long finalizing;
        private Long initializing;
        private Long started;
        private Long total;

        public Builder done(long value) {
            this.done = value;
            return this;
        }

        public Builder failed(long value) {
            this.failed = value;
            return this;
        }

        public Builder finalizing(long value) {
            this.finalizing = value;
            return this;
        }

        public Builder initializing(long value) {
            this.initializing = value;
            return this;
        }

        public Builder started(long value) {
            this.started = value;
            return this;
        }

        public Builder total(long value) {
            this.total = value;
            return this;
        }

        @Override
        public ShardsStats build() {
            return new ShardsStats(this);
        }
    }
}

