/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.PutSettingsRequest;
import co.elastic.clients.elasticsearch.snapshot.RestoreResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RestoreRequest
extends RequestBase
implements JsonpSerializable {
    private final String repository;
    private final String snapshot;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final Boolean waitForCompletion;
    @Nullable
    private final List<String> ignoreIndexSettings;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean includeAliases;
    @Nullable
    private final Boolean includeGlobalState;
    @Nullable
    private final PutSettingsRequest indexSettings;
    @Nullable
    private final List<String> indices;
    @Nullable
    private final Boolean partial;
    @Nullable
    private final String renamePattern;
    @Nullable
    private final String renameReplacement;
    public static final JsonpDeserializer<RestoreRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RestoreRequest::setupRestoreRequestDeserializer, Builder::build);
    public static final Endpoint<RestoreRequest, RestoreResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<RestoreRequest, RestoreResponse>(request -> "POST", request -> {
        boolean _repository = true;
        int _snapshot = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshot, buf);
            buf.append("/_restore");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, RestoreResponse._DESERIALIZER);

    public RestoreRequest(Builder builder) {
        this.repository = Objects.requireNonNull(builder.repository, "repository");
        this.snapshot = Objects.requireNonNull(builder.snapshot, "snapshot");
        this.masterTimeout = builder.masterTimeout;
        this.waitForCompletion = builder.waitForCompletion;
        this.ignoreIndexSettings = ModelTypeHelper.unmodifiable(builder.ignoreIndexSettings);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.includeAliases = builder.includeAliases;
        this.includeGlobalState = builder.includeGlobalState;
        this.indexSettings = builder.indexSettings;
        this.indices = ModelTypeHelper.unmodifiable(builder.indices);
        this.partial = builder.partial;
        this.renamePattern = builder.renamePattern;
        this.renameReplacement = builder.renameReplacement;
    }

    public RestoreRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String repository() {
        return this.repository;
    }

    public String snapshot() {
        return this.snapshot;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Nullable
    public List<String> ignoreIndexSettings() {
        return this.ignoreIndexSettings;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public Boolean includeAliases() {
        return this.includeAliases;
    }

    @Nullable
    public Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    @Nullable
    public PutSettingsRequest indexSettings() {
        return this.indexSettings;
    }

    @Nullable
    public List<String> indices() {
        return this.indices;
    }

    @Nullable
    public Boolean partial() {
        return this.partial;
    }

    @Nullable
    public String renamePattern() {
        return this.renamePattern;
    }

    @Nullable
    public String renameReplacement() {
        return this.renameReplacement;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.ignoreIndexSettings != null) {
            generator.writeKey("ignore_index_settings");
            generator.writeStartArray();
            for (String item0 : this.ignoreIndexSettings) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.ignoreUnavailable != null) {
            generator.writeKey("ignore_unavailable");
            generator.write(this.ignoreUnavailable.booleanValue());
        }
        if (this.includeAliases != null) {
            generator.writeKey("include_aliases");
            generator.write(this.includeAliases.booleanValue());
        }
        if (this.includeGlobalState != null) {
            generator.writeKey("include_global_state");
            generator.write(this.includeGlobalState.booleanValue());
        }
        if (this.indexSettings != null) {
            generator.writeKey("index_settings");
            this.indexSettings.serialize(generator, mapper);
        }
        if (this.indices != null) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.partial != null) {
            generator.writeKey("partial");
            generator.write(this.partial.booleanValue());
        }
        if (this.renamePattern != null) {
            generator.writeKey("rename_pattern");
            generator.write(this.renamePattern);
        }
        if (this.renameReplacement != null) {
            generator.writeKey("rename_replacement");
            generator.write(this.renameReplacement);
        }
    }

    protected static void setupRestoreRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::ignoreIndexSettings, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ignore_index_settings", new String[0]);
        op.add(Builder::ignoreUnavailable, JsonpDeserializer.booleanDeserializer(), "ignore_unavailable", new String[0]);
        op.add(Builder::includeAliases, JsonpDeserializer.booleanDeserializer(), "include_aliases", new String[0]);
        op.add(Builder::includeGlobalState, JsonpDeserializer.booleanDeserializer(), "include_global_state", new String[0]);
        op.add(Builder::indexSettings, PutSettingsRequest._DESERIALIZER, "index_settings", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices", new String[0]);
        op.add(Builder::partial, JsonpDeserializer.booleanDeserializer(), "partial", new String[0]);
        op.add(Builder::renamePattern, JsonpDeserializer.stringDeserializer(), "rename_pattern", new String[0]);
        op.add(Builder::renameReplacement, JsonpDeserializer.stringDeserializer(), "rename_replacement", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RestoreRequest> {
        private String repository;
        private String snapshot;
        @Nullable
        private String masterTimeout;
        @Nullable
        private Boolean waitForCompletion;
        @Nullable
        private List<String> ignoreIndexSettings;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean includeAliases;
        @Nullable
        private Boolean includeGlobalState;
        @Nullable
        private PutSettingsRequest indexSettings;
        @Nullable
        private List<String> indices;
        @Nullable
        private Boolean partial;
        @Nullable
        private String renamePattern;
        @Nullable
        private String renameReplacement;

        public Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        public Builder ignoreIndexSettings(@Nullable List<String> value) {
            this.ignoreIndexSettings = value;
            return this;
        }

        public Builder ignoreIndexSettings(String ... value) {
            this.ignoreIndexSettings = Arrays.asList(value);
            return this;
        }

        public Builder addIgnoreIndexSettings(String value) {
            if (this.ignoreIndexSettings == null) {
                this.ignoreIndexSettings = new ArrayList<String>();
            }
            this.ignoreIndexSettings.add(value);
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder includeAliases(@Nullable Boolean value) {
            this.includeAliases = value;
            return this;
        }

        public Builder includeGlobalState(@Nullable Boolean value) {
            this.includeGlobalState = value;
            return this;
        }

        public Builder indexSettings(@Nullable PutSettingsRequest value) {
            this.indexSettings = value;
            return this;
        }

        public Builder indexSettings(Function<PutSettingsRequest.Builder, ObjectBuilder<PutSettingsRequest>> fn) {
            return this.indexSettings(fn.apply(new PutSettingsRequest.Builder()).build());
        }

        public Builder indices(@Nullable List<String> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(String ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(String value) {
            if (this.indices == null) {
                this.indices = new ArrayList<String>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder partial(@Nullable Boolean value) {
            this.partial = value;
            return this;
        }

        public Builder renamePattern(@Nullable String value) {
            this.renamePattern = value;
            return this;
        }

        public Builder renameReplacement(@Nullable String value) {
            this.renameReplacement = value;
            return this;
        }

        @Override
        public RestoreRequest build() {
            return new RestoreRequest(this);
        }
    }
}

