/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.snapshot.CreateRepositoryResponse;
import co.elastic.clients.elasticsearch.snapshot.RepositorySettings;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CreateRepositoryRequest
extends RequestBase
implements JsonpSerializable {
    private final String repository;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    @Nullable
    private final Boolean verify;
    private final String type;
    private final RepositorySettings settings;
    public static final JsonpDeserializer<CreateRepositoryRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateRepositoryRequest::setupCreateRepositoryRequestDeserializer, Builder::build);
    public static final Endpoint<CreateRepositoryRequest, CreateRepositoryResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<CreateRepositoryRequest, CreateRepositoryResponse>(request -> "PUT", request -> {
        boolean _repository = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        if (request.verify != null) {
            params.put("verify", String.valueOf(request.verify));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, CreateRepositoryResponse._DESERIALIZER);

    public CreateRepositoryRequest(Builder builder) {
        this.repository = Objects.requireNonNull(builder.repository, "repository");
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.verify = builder.verify;
        this.type = Objects.requireNonNull(builder.type, "type");
        this.settings = Objects.requireNonNull(builder.settings, "settings");
    }

    public CreateRepositoryRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String repository() {
        return this.repository;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public Boolean verify() {
        return this.verify;
    }

    public String type() {
        return this.type;
    }

    public RepositorySettings settings() {
        return this.settings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("type");
        generator.write(this.type);
        generator.writeKey("settings");
        this.settings.serialize(generator, mapper);
    }

    protected static void setupCreateRepositoryRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
        op.add(Builder::settings, RepositorySettings._DESERIALIZER, "settings", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CreateRepositoryRequest> {
        private String repository;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;
        @Nullable
        private Boolean verify;
        private String type;
        private RepositorySettings settings;

        public Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder verify(@Nullable Boolean value) {
            this.verify = value;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        public Builder settings(RepositorySettings value) {
            this.settings = value;
            return this;
        }

        public Builder settings(Function<RepositorySettings.Builder, ObjectBuilder<RepositorySettings>> fn) {
            return this.settings(fn.apply(new RepositorySettings.Builder()).build());
        }

        @Override
        public CreateRepositoryRequest build() {
            return new CreateRepositoryRequest(this);
        }
    }
}

