/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.ApplicationPrivileges;
import co.elastic.clients.elasticsearch.security.ClusterPrivilege;
import co.elastic.clients.elasticsearch.security.IndicesPrivileges;
import co.elastic.clients.elasticsearch.security.PutRoleResponse;
import co.elastic.clients.elasticsearch.security.get_role.TransientMetadata;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutRoleRequest
extends RequestBase
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final JsonValue refresh;
    @Nullable
    private final List<ApplicationPrivileges> applications;
    @Nullable
    private final List<ClusterPrivilege> cluster;
    @Nullable
    private final Map<String, JsonData> global;
    @Nullable
    private final List<IndicesPrivileges> indices;
    @Nullable
    private final Map<String, JsonData> metadata;
    @Nullable
    private final List<String> runAs;
    @Nullable
    private final TransientMetadata transientMetadata;
    public static final JsonpDeserializer<PutRoleRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutRoleRequest::setupPutRoleRequestDeserializer, Builder::build);
    public static final Endpoint<PutRoleRequest, PutRoleResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutRoleRequest, PutRoleResponse>(request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/role");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", JsonpUtils.toString(request.refresh));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutRoleResponse._DESERIALIZER);

    public PutRoleRequest(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.refresh = builder.refresh;
        this.applications = ModelTypeHelper.unmodifiable(builder.applications);
        this.cluster = ModelTypeHelper.unmodifiable(builder.cluster);
        this.global = ModelTypeHelper.unmodifiable(builder.global);
        this.indices = ModelTypeHelper.unmodifiable(builder.indices);
        this.metadata = ModelTypeHelper.unmodifiable(builder.metadata);
        this.runAs = ModelTypeHelper.unmodifiable(builder.runAs);
        this.transientMetadata = builder.transientMetadata;
    }

    public PutRoleRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    @Nullable
    public List<ApplicationPrivileges> applications() {
        return this.applications;
    }

    @Nullable
    public List<ClusterPrivilege> cluster() {
        return this.cluster;
    }

    @Nullable
    public Map<String, JsonData> global() {
        return this.global;
    }

    @Nullable
    public List<IndicesPrivileges> indices() {
        return this.indices;
    }

    @Nullable
    public Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public List<String> runAs() {
        return this.runAs;
    }

    @Nullable
    public TransientMetadata transientMetadata() {
        return this.transientMetadata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.applications != null) {
            generator.writeKey("applications");
            generator.writeStartArray();
            for (ApplicationPrivileges applicationPrivileges : this.applications) {
                applicationPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.cluster != null) {
            generator.writeKey("cluster");
            generator.writeStartArray();
            for (ClusterPrivilege clusterPrivilege : this.cluster) {
                clusterPrivilege.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.global != null) {
            generator.writeKey("global");
            generator.writeStartObject();
            for (Map.Entry entry : this.global.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.indices != null) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (IndicesPrivileges indicesPrivileges : this.indices) {
                indicesPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.metadata != null) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.runAs != null) {
            generator.writeKey("run_as");
            generator.writeStartArray();
            for (String string : this.runAs) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.transientMetadata != null) {
            generator.writeKey("transient_metadata");
            this.transientMetadata.serialize(generator, mapper);
        }
    }

    protected static void setupPutRoleRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::applications, JsonpDeserializer.arrayDeserializer(ApplicationPrivileges._DESERIALIZER), "applications", new String[0]);
        op.add(Builder::cluster, JsonpDeserializer.arrayDeserializer(ClusterPrivilege._DESERIALIZER), "cluster", new String[0]);
        op.add(Builder::global, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "global", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(IndicesPrivileges._DESERIALIZER), "indices", new String[0]);
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata", new String[0]);
        op.add(Builder::runAs, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "run_as", new String[0]);
        op.add(Builder::transientMetadata, TransientMetadata._DESERIALIZER, "transient_metadata", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutRoleRequest> {
        private String name;
        @Nullable
        private JsonValue refresh;
        @Nullable
        private List<ApplicationPrivileges> applications;
        @Nullable
        private List<ClusterPrivilege> cluster;
        @Nullable
        private Map<String, JsonData> global;
        @Nullable
        private List<IndicesPrivileges> indices;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private List<String> runAs;
        @Nullable
        private TransientMetadata transientMetadata;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        public Builder applications(@Nullable List<ApplicationPrivileges> value) {
            this.applications = value;
            return this;
        }

        public Builder applications(ApplicationPrivileges ... value) {
            this.applications = Arrays.asList(value);
            return this;
        }

        public Builder addApplications(ApplicationPrivileges value) {
            if (this.applications == null) {
                this.applications = new ArrayList<ApplicationPrivileges>();
            }
            this.applications.add(value);
            return this;
        }

        public Builder applications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.applications(fn.apply(new ApplicationPrivileges.Builder()).build());
        }

        public Builder addApplications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.addApplications(fn.apply(new ApplicationPrivileges.Builder()).build());
        }

        public Builder cluster(@Nullable List<ClusterPrivilege> value) {
            this.cluster = value;
            return this;
        }

        public Builder cluster(ClusterPrivilege ... value) {
            this.cluster = Arrays.asList(value);
            return this;
        }

        public Builder addCluster(ClusterPrivilege value) {
            if (this.cluster == null) {
                this.cluster = new ArrayList<ClusterPrivilege>();
            }
            this.cluster.add(value);
            return this;
        }

        public Builder global(@Nullable Map<String, JsonData> value) {
            this.global = value;
            return this;
        }

        public Builder putGlobal(String key, JsonData value) {
            if (this.global == null) {
                this.global = new HashMap<String, JsonData>();
            }
            this.global.put(key, value);
            return this;
        }

        public Builder indices(@Nullable List<IndicesPrivileges> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(IndicesPrivileges ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(IndicesPrivileges value) {
            if (this.indices == null) {
                this.indices = new ArrayList<IndicesPrivileges>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder indices(Function<IndicesPrivileges.Builder, ObjectBuilder<IndicesPrivileges>> fn) {
            return this.indices(fn.apply(new IndicesPrivileges.Builder()).build());
        }

        public Builder addIndices(Function<IndicesPrivileges.Builder, ObjectBuilder<IndicesPrivileges>> fn) {
            return this.addIndices(fn.apply(new IndicesPrivileges.Builder()).build());
        }

        public Builder metadata(@Nullable Map<String, JsonData> value) {
            this.metadata = value;
            return this;
        }

        public Builder putMetadata(String key, JsonData value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, JsonData>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder runAs(@Nullable List<String> value) {
            this.runAs = value;
            return this;
        }

        public Builder runAs(String ... value) {
            this.runAs = Arrays.asList(value);
            return this;
        }

        public Builder addRunAs(String value) {
            if (this.runAs == null) {
                this.runAs = new ArrayList<String>();
            }
            this.runAs.add(value);
            return this;
        }

        public Builder transientMetadata(@Nullable TransientMetadata value) {
            this.transientMetadata = value;
            return this;
        }

        public Builder transientMetadata(Function<TransientMetadata.Builder, ObjectBuilder<TransientMetadata>> fn) {
            return this.transientMetadata(fn.apply(new TransientMetadata.Builder()).build());
        }

        @Override
        public PutRoleRequest build() {
            return new PutRoleRequest(this);
        }
    }
}

