/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.security.FieldSecurity;
import co.elastic.clients.elasticsearch.security.IndexPrivilege;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IndicesPrivileges
implements JsonpSerializable {
    @Nullable
    private final FieldSecurity fieldSecurity;
    private final List<String> names;
    private final List<IndexPrivilege> privileges;
    @Nullable
    private final Query query;
    @Nullable
    private final Boolean allowRestrictedIndices;
    public static final JsonpDeserializer<IndicesPrivileges> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesPrivileges::setupIndicesPrivilegesDeserializer, Builder::build);

    public IndicesPrivileges(Builder builder) {
        this.fieldSecurity = builder.fieldSecurity;
        this.names = ModelTypeHelper.unmodifiableNonNull(builder.names, "names");
        this.privileges = ModelTypeHelper.unmodifiableNonNull(builder.privileges, "privileges");
        this.query = builder.query;
        this.allowRestrictedIndices = builder.allowRestrictedIndices;
    }

    public IndicesPrivileges(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public FieldSecurity fieldSecurity() {
        return this.fieldSecurity;
    }

    public List<String> names() {
        return this.names;
    }

    public List<IndexPrivilege> privileges() {
        return this.privileges;
    }

    @Nullable
    public Query query() {
        return this.query;
    }

    @Nullable
    public Boolean allowRestrictedIndices() {
        return this.allowRestrictedIndices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.fieldSecurity != null) {
            generator.writeKey("field_security");
            this.fieldSecurity.serialize(generator, mapper);
        }
        generator.writeKey("names");
        generator.writeStartArray();
        for (String string : this.names) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("privileges");
        generator.writeStartArray();
        for (IndexPrivilege indexPrivilege : this.privileges) {
            indexPrivilege.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.allowRestrictedIndices != null) {
            generator.writeKey("allow_restricted_indices");
            generator.write(this.allowRestrictedIndices.booleanValue());
        }
    }

    protected static void setupIndicesPrivilegesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::fieldSecurity, FieldSecurity._DESERIALIZER, "field_security", new String[0]);
        op.add(Builder::names, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "names", new String[0]);
        op.add(Builder::privileges, JsonpDeserializer.arrayDeserializer(IndexPrivilege._DESERIALIZER), "privileges", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::allowRestrictedIndices, JsonpDeserializer.booleanDeserializer(), "allow_restricted_indices", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndicesPrivileges> {
        @Nullable
        private FieldSecurity fieldSecurity;
        private List<String> names;
        private List<IndexPrivilege> privileges;
        @Nullable
        private Query query;
        @Nullable
        private Boolean allowRestrictedIndices;

        public Builder fieldSecurity(@Nullable FieldSecurity value) {
            this.fieldSecurity = value;
            return this;
        }

        public Builder fieldSecurity(Function<FieldSecurity.Builder, ObjectBuilder<FieldSecurity>> fn) {
            return this.fieldSecurity(fn.apply(new FieldSecurity.Builder()).build());
        }

        public Builder names(List<String> value) {
            this.names = value;
            return this;
        }

        public Builder names(String ... value) {
            this.names = Arrays.asList(value);
            return this;
        }

        public Builder addNames(String value) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(value);
            return this;
        }

        public Builder privileges(List<IndexPrivilege> value) {
            this.privileges = value;
            return this;
        }

        public Builder privileges(IndexPrivilege ... value) {
            this.privileges = Arrays.asList(value);
            return this;
        }

        public Builder addPrivileges(IndexPrivilege value) {
            if (this.privileges == null) {
                this.privileges = new ArrayList<IndexPrivilege>();
            }
            this.privileges.add(value);
            return this;
        }

        public Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder allowRestrictedIndices(@Nullable Boolean value) {
            this.allowRestrictedIndices = value;
            return this;
        }

        @Override
        public IndicesPrivileges build() {
            return new IndicesPrivileges(this);
        }
    }
}

