/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.ApplicationPrivileges;
import co.elastic.clients.elasticsearch.security.GlobalPrivilege;
import co.elastic.clients.elasticsearch.security.IndicesPrivileges;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class GetUserPrivilegesResponse
implements JsonpSerializable {
    private final List<ApplicationPrivileges> applications;
    private final List<String> cluster;
    private final List<GlobalPrivilege> global;
    private final List<IndicesPrivileges> indices;
    private final List<String> runAs;
    public static final JsonpDeserializer<GetUserPrivilegesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetUserPrivilegesResponse::setupGetUserPrivilegesResponseDeserializer, Builder::build);

    public GetUserPrivilegesResponse(Builder builder) {
        this.applications = ModelTypeHelper.unmodifiableNonNull(builder.applications, "applications");
        this.cluster = ModelTypeHelper.unmodifiableNonNull(builder.cluster, "cluster");
        this.global = ModelTypeHelper.unmodifiableNonNull(builder.global, "global");
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
        this.runAs = ModelTypeHelper.unmodifiableNonNull(builder.runAs, "run_as");
    }

    public GetUserPrivilegesResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<ApplicationPrivileges> applications() {
        return this.applications;
    }

    public List<String> cluster() {
        return this.cluster;
    }

    public List<GlobalPrivilege> global() {
        return this.global;
    }

    public List<IndicesPrivileges> indices() {
        return this.indices;
    }

    public List<String> runAs() {
        return this.runAs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("applications");
        generator.writeStartArray();
        for (ApplicationPrivileges applicationPrivileges : this.applications) {
            applicationPrivileges.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("cluster");
        generator.writeStartArray();
        for (String string : this.cluster) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("global");
        generator.writeStartArray();
        for (GlobalPrivilege globalPrivilege : this.global) {
            globalPrivilege.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("indices");
        generator.writeStartArray();
        for (IndicesPrivileges indicesPrivileges : this.indices) {
            indicesPrivileges.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("run_as");
        generator.writeStartArray();
        for (String string : this.runAs) {
            generator.write(string);
        }
        generator.writeEnd();
    }

    protected static void setupGetUserPrivilegesResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::applications, JsonpDeserializer.arrayDeserializer(ApplicationPrivileges._DESERIALIZER), "applications", new String[0]);
        op.add(Builder::cluster, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "cluster", new String[0]);
        op.add(Builder::global, JsonpDeserializer.arrayDeserializer(GlobalPrivilege._DESERIALIZER), "global", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(IndicesPrivileges._DESERIALIZER), "indices", new String[0]);
        op.add(Builder::runAs, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "run_as", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetUserPrivilegesResponse> {
        private List<ApplicationPrivileges> applications;
        private List<String> cluster;
        private List<GlobalPrivilege> global;
        private List<IndicesPrivileges> indices;
        private List<String> runAs;

        public Builder applications(List<ApplicationPrivileges> value) {
            this.applications = value;
            return this;
        }

        public Builder applications(ApplicationPrivileges ... value) {
            this.applications = Arrays.asList(value);
            return this;
        }

        public Builder addApplications(ApplicationPrivileges value) {
            if (this.applications == null) {
                this.applications = new ArrayList<ApplicationPrivileges>();
            }
            this.applications.add(value);
            return this;
        }

        public Builder applications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.applications(fn.apply(new ApplicationPrivileges.Builder()).build());
        }

        public Builder addApplications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.addApplications(fn.apply(new ApplicationPrivileges.Builder()).build());
        }

        public Builder cluster(List<String> value) {
            this.cluster = value;
            return this;
        }

        public Builder cluster(String ... value) {
            this.cluster = Arrays.asList(value);
            return this;
        }

        public Builder addCluster(String value) {
            if (this.cluster == null) {
                this.cluster = new ArrayList<String>();
            }
            this.cluster.add(value);
            return this;
        }

        public Builder global(List<GlobalPrivilege> value) {
            this.global = value;
            return this;
        }

        public Builder global(GlobalPrivilege ... value) {
            this.global = Arrays.asList(value);
            return this;
        }

        public Builder addGlobal(GlobalPrivilege value) {
            if (this.global == null) {
                this.global = new ArrayList<GlobalPrivilege>();
            }
            this.global.add(value);
            return this;
        }

        public Builder global(Function<GlobalPrivilege.Builder, ObjectBuilder<GlobalPrivilege>> fn) {
            return this.global(fn.apply(new GlobalPrivilege.Builder()).build());
        }

        public Builder addGlobal(Function<GlobalPrivilege.Builder, ObjectBuilder<GlobalPrivilege>> fn) {
            return this.addGlobal(fn.apply(new GlobalPrivilege.Builder()).build());
        }

        public Builder indices(List<IndicesPrivileges> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(IndicesPrivileges ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(IndicesPrivileges value) {
            if (this.indices == null) {
                this.indices = new ArrayList<IndicesPrivileges>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder indices(Function<IndicesPrivileges.Builder, ObjectBuilder<IndicesPrivileges>> fn) {
            return this.indices(fn.apply(new IndicesPrivileges.Builder()).build());
        }

        public Builder addIndices(Function<IndicesPrivileges.Builder, ObjectBuilder<IndicesPrivileges>> fn) {
            return this.addIndices(fn.apply(new IndicesPrivileges.Builder()).build());
        }

        public Builder runAs(List<String> value) {
            this.runAs = value;
            return this;
        }

        public Builder runAs(String ... value) {
            this.runAs = Arrays.asList(value);
            return this;
        }

        public Builder addRunAs(String value) {
            if (this.runAs == null) {
                this.runAs = new ArrayList<String>();
            }
            this.runAs.add(value);
            return this;
        }

        @Override
        public GetUserPrivilegesResponse build() {
            return new GetUserPrivilegesResponse(this);
        }
    }
}

