/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.GetServiceAccountsResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetServiceAccountsRequest
extends RequestBase {
    @Nullable
    private final String namespace;
    @Nullable
    private final String service;
    public static final Endpoint<GetServiceAccountsRequest, GetServiceAccountsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetServiceAccountsRequest, GetServiceAccountsResponse>(request -> "GET", request -> {
        boolean _namespace = true;
        int _service = 2;
        int propsSet = 0;
        if (request.namespace() != null) {
            propsSet |= 1;
        }
        if (request.service() != null) {
            propsSet |= 2;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/service");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.namespace, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.service, buf);
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/service");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.namespace, buf);
            return buf.toString();
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/service");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, GetServiceAccountsResponse._DESERIALIZER);

    public GetServiceAccountsRequest(Builder builder) {
        this.namespace = builder.namespace;
        this.service = builder.service;
    }

    public GetServiceAccountsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String namespace() {
        return this.namespace;
    }

    @Nullable
    public String service() {
        return this.service;
    }

    public static class Builder
    implements ObjectBuilder<GetServiceAccountsRequest> {
        @Nullable
        private String namespace;
        @Nullable
        private String service;

        public Builder namespace(@Nullable String value) {
            this.namespace = value;
            return this;
        }

        public Builder service(@Nullable String value) {
            this.service = value;
            return this;
        }

        @Override
        public GetServiceAccountsRequest build() {
            return new GetServiceAccountsRequest(this);
        }
    }
}

