/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.GetRoleResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetRoleRequest
extends RequestBase {
    @Nullable
    private final String name;
    public static final Endpoint<GetRoleRequest, GetRoleResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetRoleRequest, GetRoleResponse>(request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/role");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/role");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, GetRoleResponse._DESERIALIZER);

    public GetRoleRequest(Builder builder) {
        this.name = builder.name;
    }

    public GetRoleRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String name() {
        return this.name;
    }

    public static class Builder
    implements ObjectBuilder<GetRoleRequest> {
        @Nullable
        private String name;

        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Override
        public GetRoleRequest build() {
            return new GetRoleRequest(this);
        }
    }
}

