/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.FieldRuleVariant;
import co.elastic.clients.elasticsearch.security.Realm;
import co.elastic.clients.elasticsearch.security.RoleMappingRuleVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class FieldRule
implements TaggedUnion<Object>,
RoleMappingRuleVariant,
JsonpSerializable {
    public static final String USERNAME = "username";
    public static final String DN = "dn";
    public static final String GROUPS = "groups";
    public static final String METADATA = "metadata";
    public static final String REALM = "realm";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<FieldRule> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, FieldRule::setupFieldRuleDeserializer, Builder::build);

    @Override
    public String _variantType() {
        return "field";
    }

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public FieldRule(FieldRuleVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    public <T extends FieldRuleVariant> FieldRule(ObjectBuilder<T> builder) {
        this((FieldRuleVariant)builder.build());
    }

    private FieldRule(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public FieldRule(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String username() {
        return (String)TaggedUnionUtils.get(this, USERNAME);
    }

    public List<String> dn() {
        return (List)TaggedUnionUtils.get(this, DN);
    }

    public List<String> groups() {
        return (List)TaggedUnionUtils.get(this, GROUPS);
    }

    public JsonData metadata() {
        return (JsonData)TaggedUnionUtils.get(this, METADATA);
    }

    public Realm realm() {
        return (Realm)TaggedUnionUtils.get(this, REALM);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._type) {
                case "username": {
                    generator.write((String)this._value);
                    break;
                }
                case "dn": {
                    generator.writeStartArray();
                    for (String item0 : (List)this._value) {
                        generator.write(item0);
                    }
                    generator.writeEnd();
                    break;
                }
                case "groups": {
                    generator.writeStartArray();
                    for (String item0 : (List)this._value) {
                        generator.write(item0);
                    }
                    generator.writeEnd();
                    break;
                }
                case "metadata": {
                    ((JsonData)this._value).serialize(generator, mapper);
                }
            }
        }
        generator.writeEnd();
    }

    protected static void setupFieldRuleDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), USERNAME, new String[0]);
        op.add(Builder::dn, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), DN, new String[0]);
        op.add(Builder::groups, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), GROUPS, new String[0]);
        op.add(Builder::metadata, JsonData._DESERIALIZER, METADATA, new String[0]);
        op.add(Builder::realm, Realm._DESERIALIZER, REALM, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FieldRule> {
        private String _type;
        private Object _value;

        public Builder username(String v) {
            this._type = FieldRule.USERNAME;
            this._value = v;
            return this;
        }

        public Builder dn(List<String> v) {
            this._type = FieldRule.DN;
            this._value = v;
            return this;
        }

        public Builder groups(List<String> v) {
            this._type = FieldRule.GROUPS;
            this._value = v;
            return this;
        }

        public Builder metadata(JsonData v) {
            this._type = FieldRule.METADATA;
            this._value = v;
            return this;
        }

        public Builder realm(Realm v) {
            this._type = FieldRule.REALM;
            this._value = v;
            return this;
        }

        public Builder realm(Function<Realm.Builder, ObjectBuilder<Realm>> f) {
            return this.realm(f.apply(new Realm.Builder()).build());
        }

        @Override
        public FieldRule build() {
            return new FieldRule(this);
        }
    }
}

