/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.searchable_snapshots;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.searchable_snapshots.MountResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class MountRequest
extends RequestBase
implements JsonpSerializable {
    private final String repository;
    private final String snapshot;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final Boolean waitForCompletion;
    @Nullable
    private final String storage;
    private final String index;
    @Nullable
    private final String renamedIndex;
    @Nullable
    private final Map<String, JsonData> indexSettings;
    @Nullable
    private final List<String> ignoreIndexSettings;
    public static final JsonpDeserializer<MountRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MountRequest::setupMountRequestDeserializer, Builder::build);
    public static final Endpoint<MountRequest, MountResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<MountRequest, MountResponse>(request -> "POST", request -> {
        boolean _repository = true;
        int _snapshot = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshot, buf);
            buf.append("/_mount");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        if (request.storage != null) {
            params.put("storage", request.storage);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, MountResponse._DESERIALIZER);

    public MountRequest(Builder builder) {
        this.repository = Objects.requireNonNull(builder.repository, "repository");
        this.snapshot = Objects.requireNonNull(builder.snapshot, "snapshot");
        this.masterTimeout = builder.masterTimeout;
        this.waitForCompletion = builder.waitForCompletion;
        this.storage = builder.storage;
        this.index = Objects.requireNonNull(builder.index, "index");
        this.renamedIndex = builder.renamedIndex;
        this.indexSettings = ModelTypeHelper.unmodifiable(builder.indexSettings);
        this.ignoreIndexSettings = ModelTypeHelper.unmodifiable(builder.ignoreIndexSettings);
    }

    public MountRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String repository() {
        return this.repository;
    }

    public String snapshot() {
        return this.snapshot;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Nullable
    public String storage() {
        return this.storage;
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public String renamedIndex() {
        return this.renamedIndex;
    }

    @Nullable
    public Map<String, JsonData> indexSettings() {
        return this.indexSettings;
    }

    @Nullable
    public List<String> ignoreIndexSettings() {
        return this.ignoreIndexSettings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        if (this.renamedIndex != null) {
            generator.writeKey("renamed_index");
            generator.write(this.renamedIndex);
        }
        if (this.indexSettings != null) {
            generator.writeKey("index_settings");
            generator.writeStartObject();
            for (Map.Entry entry : this.indexSettings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ignoreIndexSettings != null) {
            generator.writeKey("ignore_index_settings");
            generator.writeStartArray();
            for (String string : this.ignoreIndexSettings) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    protected static void setupMountRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::renamedIndex, JsonpDeserializer.stringDeserializer(), "renamed_index", new String[0]);
        op.add(Builder::indexSettings, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "index_settings", new String[0]);
        op.add(Builder::ignoreIndexSettings, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ignore_index_settings", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<MountRequest> {
        private String repository;
        private String snapshot;
        @Nullable
        private String masterTimeout;
        @Nullable
        private Boolean waitForCompletion;
        @Nullable
        private String storage;
        private String index;
        @Nullable
        private String renamedIndex;
        @Nullable
        private Map<String, JsonData> indexSettings;
        @Nullable
        private List<String> ignoreIndexSettings;

        public Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        public Builder storage(@Nullable String value) {
            this.storage = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder renamedIndex(@Nullable String value) {
            this.renamedIndex = value;
            return this;
        }

        public Builder indexSettings(@Nullable Map<String, JsonData> value) {
            this.indexSettings = value;
            return this;
        }

        public Builder putIndexSettings(String key, JsonData value) {
            if (this.indexSettings == null) {
                this.indexSettings = new HashMap<String, JsonData>();
            }
            this.indexSettings.put(key, value);
            return this;
        }

        public Builder ignoreIndexSettings(@Nullable List<String> value) {
            this.ignoreIndexSettings = value;
            return this;
        }

        public Builder ignoreIndexSettings(String ... value) {
            this.ignoreIndexSettings = Arrays.asList(value);
            return this;
        }

        public Builder addIgnoreIndexSettings(String value) {
            if (this.ignoreIndexSettings == null) {
                this.ignoreIndexSettings = new ArrayList<String>();
            }
            this.ignoreIndexSettings.add(value);
            return this;
        }

        @Override
        public MountRequest build() {
            return new MountRequest(this);
        }
    }
}

