/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class HistogramGrouping
implements JsonpSerializable {
    private final List<String> fields;
    private final long interval;
    public static final JsonpDeserializer<HistogramGrouping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HistogramGrouping::setupHistogramGroupingDeserializer, Builder::build);

    public HistogramGrouping(Builder builder) {
        this.fields = ModelTypeHelper.unmodifiableNonNull(builder.fields, "fields");
        this.interval = Objects.requireNonNull(builder.interval, "interval");
    }

    public HistogramGrouping(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> fields() {
        return this.fields;
    }

    public long interval() {
        return this.interval;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("fields");
        generator.writeStartArray();
        for (String item0 : this.fields) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("interval");
        generator.write(this.interval);
    }

    protected static void setupHistogramGroupingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields", new String[0]);
        op.add(Builder::interval, JsonpDeserializer.longDeserializer(), "interval", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<HistogramGrouping> {
        private List<String> fields;
        private Long interval;

        public Builder fields(List<String> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(String ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder interval(long value) {
            this.interval = value;
            return this;
        }

        @Override
        public HistogramGrouping build() {
            return new HistogramGrouping(this);
        }
    }
}

