/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NodeThreadPoolInfo
implements JsonpSerializable {
    @Nullable
    private final Integer core;
    @Nullable
    private final String keepAlive;
    @Nullable
    private final Integer max;
    private final int queueSize;
    @Nullable
    private final Integer size;
    private final String type;
    public static final JsonpDeserializer<NodeThreadPoolInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeThreadPoolInfo::setupNodeThreadPoolInfoDeserializer, Builder::build);

    public NodeThreadPoolInfo(Builder builder) {
        this.core = builder.core;
        this.keepAlive = builder.keepAlive;
        this.max = builder.max;
        this.queueSize = Objects.requireNonNull(builder.queueSize, "queue_size");
        this.size = builder.size;
        this.type = Objects.requireNonNull(builder.type, "type");
    }

    public NodeThreadPoolInfo(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Integer core() {
        return this.core;
    }

    @Nullable
    public String keepAlive() {
        return this.keepAlive;
    }

    @Nullable
    public Integer max() {
        return this.max;
    }

    public int queueSize() {
        return this.queueSize;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    public String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.core != null) {
            generator.writeKey("core");
            generator.write(this.core.intValue());
        }
        if (this.keepAlive != null) {
            generator.writeKey("keep_alive");
            generator.write(this.keepAlive);
        }
        if (this.max != null) {
            generator.writeKey("max");
            generator.write(this.max.intValue());
        }
        generator.writeKey("queue_size");
        generator.write(this.queueSize);
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupNodeThreadPoolInfoDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::core, JsonpDeserializer.integerDeserializer(), "core", new String[0]);
        op.add(Builder::keepAlive, JsonpDeserializer.stringDeserializer(), "keep_alive", new String[0]);
        op.add(Builder::max, JsonpDeserializer.integerDeserializer(), "max", new String[0]);
        op.add(Builder::queueSize, JsonpDeserializer.integerDeserializer(), "queue_size", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeThreadPoolInfo> {
        @Nullable
        private Integer core;
        @Nullable
        private String keepAlive;
        @Nullable
        private Integer max;
        private Integer queueSize;
        @Nullable
        private Integer size;
        private String type;

        public Builder core(@Nullable Integer value) {
            this.core = value;
            return this;
        }

        public Builder keepAlive(@Nullable String value) {
            this.keepAlive = value;
            return this;
        }

        public Builder max(@Nullable Integer value) {
            this.max = value;
            return this;
        }

        public Builder queueSize(int value) {
            this.queueSize = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        public NodeThreadPoolInfo build() {
            return new NodeThreadPoolInfo(this);
        }
    }
}

