/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.elasticsearch.nodes.info.NodeInfoJvmMemory;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NodeJvmInfo
implements JsonpSerializable {
    private final List<String> gcCollectors;
    private final NodeInfoJvmMemory mem;
    private final List<String> memoryPools;
    private final int pid;
    private final long startTimeInMillis;
    private final String version;
    private final String vmName;
    private final String vmVendor;
    private final String vmVersion;
    private final boolean bundledJdk;
    private final boolean usingBundledJdk;
    @Nullable
    private final Boolean usingCompressedOrdinaryObjectPointers;
    private final List<String> inputArguments;
    public static final JsonpDeserializer<NodeJvmInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeJvmInfo::setupNodeJvmInfoDeserializer, Builder::build);

    public NodeJvmInfo(Builder builder) {
        this.gcCollectors = ModelTypeHelper.unmodifiableNonNull(builder.gcCollectors, "gc_collectors");
        this.mem = Objects.requireNonNull(builder.mem, "mem");
        this.memoryPools = ModelTypeHelper.unmodifiableNonNull(builder.memoryPools, "memory_pools");
        this.pid = Objects.requireNonNull(builder.pid, "pid");
        this.startTimeInMillis = Objects.requireNonNull(builder.startTimeInMillis, "start_time_in_millis");
        this.version = Objects.requireNonNull(builder.version, "version");
        this.vmName = Objects.requireNonNull(builder.vmName, "vm_name");
        this.vmVendor = Objects.requireNonNull(builder.vmVendor, "vm_vendor");
        this.vmVersion = Objects.requireNonNull(builder.vmVersion, "vm_version");
        this.bundledJdk = Objects.requireNonNull(builder.bundledJdk, "bundled_jdk");
        this.usingBundledJdk = Objects.requireNonNull(builder.usingBundledJdk, "using_bundled_jdk");
        this.usingCompressedOrdinaryObjectPointers = builder.usingCompressedOrdinaryObjectPointers;
        this.inputArguments = ModelTypeHelper.unmodifiableNonNull(builder.inputArguments, "input_arguments");
    }

    public NodeJvmInfo(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> gcCollectors() {
        return this.gcCollectors;
    }

    public NodeInfoJvmMemory mem() {
        return this.mem;
    }

    public List<String> memoryPools() {
        return this.memoryPools;
    }

    public int pid() {
        return this.pid;
    }

    public long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    public String version() {
        return this.version;
    }

    public String vmName() {
        return this.vmName;
    }

    public String vmVendor() {
        return this.vmVendor;
    }

    public String vmVersion() {
        return this.vmVersion;
    }

    public boolean bundledJdk() {
        return this.bundledJdk;
    }

    public boolean usingBundledJdk() {
        return this.usingBundledJdk;
    }

    @Nullable
    public Boolean usingCompressedOrdinaryObjectPointers() {
        return this.usingCompressedOrdinaryObjectPointers;
    }

    public List<String> inputArguments() {
        return this.inputArguments;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("gc_collectors");
        generator.writeStartArray();
        for (String item0 : this.gcCollectors) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        generator.writeKey("memory_pools");
        generator.writeStartArray();
        for (String item0 : this.memoryPools) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("pid");
        generator.write(this.pid);
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("vm_name");
        generator.write(this.vmName);
        generator.writeKey("vm_vendor");
        generator.write(this.vmVendor);
        generator.writeKey("vm_version");
        generator.write(this.vmVersion);
        generator.writeKey("bundled_jdk");
        generator.write(this.bundledJdk);
        generator.writeKey("using_bundled_jdk");
        generator.write(this.usingBundledJdk);
        if (this.usingCompressedOrdinaryObjectPointers != null) {
            generator.writeKey("using_compressed_ordinary_object_pointers");
            generator.write(this.usingCompressedOrdinaryObjectPointers.booleanValue());
        }
        generator.writeKey("input_arguments");
        generator.writeStartArray();
        for (String item0 : this.inputArguments) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupNodeJvmInfoDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::gcCollectors, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "gc_collectors", new String[0]);
        op.add(Builder::mem, NodeInfoJvmMemory._DESERIALIZER, "mem", new String[0]);
        op.add(Builder::memoryPools, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "memory_pools", new String[0]);
        op.add(Builder::pid, JsonpDeserializer.integerDeserializer(), "pid", new String[0]);
        op.add(Builder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis", new String[0]);
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
        op.add(Builder::vmName, JsonpDeserializer.stringDeserializer(), "vm_name", new String[0]);
        op.add(Builder::vmVendor, JsonpDeserializer.stringDeserializer(), "vm_vendor", new String[0]);
        op.add(Builder::vmVersion, JsonpDeserializer.stringDeserializer(), "vm_version", new String[0]);
        op.add(Builder::bundledJdk, JsonpDeserializer.booleanDeserializer(), "bundled_jdk", new String[0]);
        op.add(Builder::usingBundledJdk, JsonpDeserializer.booleanDeserializer(), "using_bundled_jdk", new String[0]);
        op.add(Builder::usingCompressedOrdinaryObjectPointers, JsonpDeserializer.booleanDeserializer(), "using_compressed_ordinary_object_pointers", new String[0]);
        op.add(Builder::inputArguments, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "input_arguments", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeJvmInfo> {
        private List<String> gcCollectors;
        private NodeInfoJvmMemory mem;
        private List<String> memoryPools;
        private Integer pid;
        private Long startTimeInMillis;
        private String version;
        private String vmName;
        private String vmVendor;
        private String vmVersion;
        private Boolean bundledJdk;
        private Boolean usingBundledJdk;
        @Nullable
        private Boolean usingCompressedOrdinaryObjectPointers;
        private List<String> inputArguments;

        public Builder gcCollectors(List<String> value) {
            this.gcCollectors = value;
            return this;
        }

        public Builder gcCollectors(String ... value) {
            this.gcCollectors = Arrays.asList(value);
            return this;
        }

        public Builder addGcCollectors(String value) {
            if (this.gcCollectors == null) {
                this.gcCollectors = new ArrayList<String>();
            }
            this.gcCollectors.add(value);
            return this;
        }

        public Builder mem(NodeInfoJvmMemory value) {
            this.mem = value;
            return this;
        }

        public Builder mem(Function<NodeInfoJvmMemory.Builder, ObjectBuilder<NodeInfoJvmMemory>> fn) {
            return this.mem(fn.apply(new NodeInfoJvmMemory.Builder()).build());
        }

        public Builder memoryPools(List<String> value) {
            this.memoryPools = value;
            return this;
        }

        public Builder memoryPools(String ... value) {
            this.memoryPools = Arrays.asList(value);
            return this;
        }

        public Builder addMemoryPools(String value) {
            if (this.memoryPools == null) {
                this.memoryPools = new ArrayList<String>();
            }
            this.memoryPools.add(value);
            return this;
        }

        public Builder pid(int value) {
            this.pid = value;
            return this;
        }

        public Builder startTimeInMillis(long value) {
            this.startTimeInMillis = value;
            return this;
        }

        public Builder version(String value) {
            this.version = value;
            return this;
        }

        public Builder vmName(String value) {
            this.vmName = value;
            return this;
        }

        public Builder vmVendor(String value) {
            this.vmVendor = value;
            return this;
        }

        public Builder vmVersion(String value) {
            this.vmVersion = value;
            return this;
        }

        public Builder bundledJdk(boolean value) {
            this.bundledJdk = value;
            return this;
        }

        public Builder usingBundledJdk(boolean value) {
            this.usingBundledJdk = value;
            return this;
        }

        public Builder usingCompressedOrdinaryObjectPointers(@Nullable Boolean value) {
            this.usingCompressedOrdinaryObjectPointers = value;
            return this;
        }

        public Builder inputArguments(List<String> value) {
            this.inputArguments = value;
            return this;
        }

        public Builder inputArguments(String ... value) {
            this.inputArguments = Arrays.asList(value);
            return this;
        }

        public Builder addInputArguments(String value) {
            if (this.inputArguments == null) {
                this.inputArguments = new ArrayList<String>();
            }
            this.inputArguments.add(value);
            return this;
        }

        @Override
        public NodeJvmInfo build() {
            return new NodeJvmInfo(this);
        }
    }
}

