/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.elasticsearch.nodes.info.NodeInfoAction;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoBootstrap;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoClient;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoDiscover;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoPath;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoRepositories;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoScript;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSearch;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsCluster;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsHttp;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsIngest;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsNetwork;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsNode;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsTransport;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoXpack;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NodeInfoSettings
implements JsonpSerializable {
    private final NodeInfoSettingsCluster cluster;
    private final NodeInfoSettingsNode node;
    private final NodeInfoPath path;
    @Nullable
    private final NodeInfoRepositories repositories;
    @Nullable
    private final NodeInfoDiscover discovery;
    @Nullable
    private final NodeInfoAction action;
    private final NodeInfoClient client;
    private final NodeInfoSettingsHttp http;
    @Nullable
    private final NodeInfoBootstrap bootstrap;
    private final NodeInfoSettingsTransport transport;
    @Nullable
    private final NodeInfoSettingsNetwork network;
    @Nullable
    private final NodeInfoXpack xpack;
    @Nullable
    private final NodeInfoScript script;
    @Nullable
    private final NodeInfoSearch search;
    @Nullable
    private final NodeInfoSettingsIngest ingest;
    public static final JsonpDeserializer<NodeInfoSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoSettings::setupNodeInfoSettingsDeserializer, Builder::build);

    public NodeInfoSettings(Builder builder) {
        this.cluster = Objects.requireNonNull(builder.cluster, "cluster");
        this.node = Objects.requireNonNull(builder.node, "node");
        this.path = Objects.requireNonNull(builder.path, "path");
        this.repositories = builder.repositories;
        this.discovery = builder.discovery;
        this.action = builder.action;
        this.client = Objects.requireNonNull(builder.client, "client");
        this.http = Objects.requireNonNull(builder.http, "http");
        this.bootstrap = builder.bootstrap;
        this.transport = Objects.requireNonNull(builder.transport, "transport");
        this.network = builder.network;
        this.xpack = builder.xpack;
        this.script = builder.script;
        this.search = builder.search;
        this.ingest = builder.ingest;
    }

    public NodeInfoSettings(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public NodeInfoSettingsCluster cluster() {
        return this.cluster;
    }

    public NodeInfoSettingsNode node() {
        return this.node;
    }

    public NodeInfoPath path() {
        return this.path;
    }

    @Nullable
    public NodeInfoRepositories repositories() {
        return this.repositories;
    }

    @Nullable
    public NodeInfoDiscover discovery() {
        return this.discovery;
    }

    @Nullable
    public NodeInfoAction action() {
        return this.action;
    }

    public NodeInfoClient client() {
        return this.client;
    }

    public NodeInfoSettingsHttp http() {
        return this.http;
    }

    @Nullable
    public NodeInfoBootstrap bootstrap() {
        return this.bootstrap;
    }

    public NodeInfoSettingsTransport transport() {
        return this.transport;
    }

    @Nullable
    public NodeInfoSettingsNetwork network() {
        return this.network;
    }

    @Nullable
    public NodeInfoXpack xpack() {
        return this.xpack;
    }

    @Nullable
    public NodeInfoScript script() {
        return this.script;
    }

    @Nullable
    public NodeInfoSearch search() {
        return this.search;
    }

    @Nullable
    public NodeInfoSettingsIngest ingest() {
        return this.ingest;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cluster");
        this.cluster.serialize(generator, mapper);
        generator.writeKey("node");
        this.node.serialize(generator, mapper);
        generator.writeKey("path");
        this.path.serialize(generator, mapper);
        if (this.repositories != null) {
            generator.writeKey("repositories");
            this.repositories.serialize(generator, mapper);
        }
        if (this.discovery != null) {
            generator.writeKey("discovery");
            this.discovery.serialize(generator, mapper);
        }
        if (this.action != null) {
            generator.writeKey("action");
            this.action.serialize(generator, mapper);
        }
        generator.writeKey("client");
        this.client.serialize(generator, mapper);
        generator.writeKey("http");
        this.http.serialize(generator, mapper);
        if (this.bootstrap != null) {
            generator.writeKey("bootstrap");
            this.bootstrap.serialize(generator, mapper);
        }
        generator.writeKey("transport");
        this.transport.serialize(generator, mapper);
        if (this.network != null) {
            generator.writeKey("network");
            this.network.serialize(generator, mapper);
        }
        if (this.xpack != null) {
            generator.writeKey("xpack");
            this.xpack.serialize(generator, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.search != null) {
            generator.writeKey("search");
            this.search.serialize(generator, mapper);
        }
        if (this.ingest != null) {
            generator.writeKey("ingest");
            this.ingest.serialize(generator, mapper);
        }
    }

    protected static void setupNodeInfoSettingsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::cluster, NodeInfoSettingsCluster._DESERIALIZER, "cluster", new String[0]);
        op.add(Builder::node, NodeInfoSettingsNode._DESERIALIZER, "node", new String[0]);
        op.add(Builder::path, NodeInfoPath._DESERIALIZER, "path", new String[0]);
        op.add(Builder::repositories, NodeInfoRepositories._DESERIALIZER, "repositories", new String[0]);
        op.add(Builder::discovery, NodeInfoDiscover._DESERIALIZER, "discovery", new String[0]);
        op.add(Builder::action, NodeInfoAction._DESERIALIZER, "action", new String[0]);
        op.add(Builder::client, NodeInfoClient._DESERIALIZER, "client", new String[0]);
        op.add(Builder::http, NodeInfoSettingsHttp._DESERIALIZER, "http", new String[0]);
        op.add(Builder::bootstrap, NodeInfoBootstrap._DESERIALIZER, "bootstrap", new String[0]);
        op.add(Builder::transport, NodeInfoSettingsTransport._DESERIALIZER, "transport", new String[0]);
        op.add(Builder::network, NodeInfoSettingsNetwork._DESERIALIZER, "network", new String[0]);
        op.add(Builder::xpack, NodeInfoXpack._DESERIALIZER, "xpack", new String[0]);
        op.add(Builder::script, NodeInfoScript._DESERIALIZER, "script", new String[0]);
        op.add(Builder::search, NodeInfoSearch._DESERIALIZER, "search", new String[0]);
        op.add(Builder::ingest, NodeInfoSettingsIngest._DESERIALIZER, "ingest", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeInfoSettings> {
        private NodeInfoSettingsCluster cluster;
        private NodeInfoSettingsNode node;
        private NodeInfoPath path;
        @Nullable
        private NodeInfoRepositories repositories;
        @Nullable
        private NodeInfoDiscover discovery;
        @Nullable
        private NodeInfoAction action;
        private NodeInfoClient client;
        private NodeInfoSettingsHttp http;
        @Nullable
        private NodeInfoBootstrap bootstrap;
        private NodeInfoSettingsTransport transport;
        @Nullable
        private NodeInfoSettingsNetwork network;
        @Nullable
        private NodeInfoXpack xpack;
        @Nullable
        private NodeInfoScript script;
        @Nullable
        private NodeInfoSearch search;
        @Nullable
        private NodeInfoSettingsIngest ingest;

        public Builder cluster(NodeInfoSettingsCluster value) {
            this.cluster = value;
            return this;
        }

        public Builder cluster(Function<NodeInfoSettingsCluster.Builder, ObjectBuilder<NodeInfoSettingsCluster>> fn) {
            return this.cluster(fn.apply(new NodeInfoSettingsCluster.Builder()).build());
        }

        public Builder node(NodeInfoSettingsNode value) {
            this.node = value;
            return this;
        }

        public Builder node(Function<NodeInfoSettingsNode.Builder, ObjectBuilder<NodeInfoSettingsNode>> fn) {
            return this.node(fn.apply(new NodeInfoSettingsNode.Builder()).build());
        }

        public Builder path(NodeInfoPath value) {
            this.path = value;
            return this;
        }

        public Builder path(Function<NodeInfoPath.Builder, ObjectBuilder<NodeInfoPath>> fn) {
            return this.path(fn.apply(new NodeInfoPath.Builder()).build());
        }

        public Builder repositories(@Nullable NodeInfoRepositories value) {
            this.repositories = value;
            return this;
        }

        public Builder repositories(Function<NodeInfoRepositories.Builder, ObjectBuilder<NodeInfoRepositories>> fn) {
            return this.repositories(fn.apply(new NodeInfoRepositories.Builder()).build());
        }

        public Builder discovery(@Nullable NodeInfoDiscover value) {
            this.discovery = value;
            return this;
        }

        public Builder discovery(Function<NodeInfoDiscover.Builder, ObjectBuilder<NodeInfoDiscover>> fn) {
            return this.discovery(fn.apply(new NodeInfoDiscover.Builder()).build());
        }

        public Builder action(@Nullable NodeInfoAction value) {
            this.action = value;
            return this;
        }

        public Builder action(Function<NodeInfoAction.Builder, ObjectBuilder<NodeInfoAction>> fn) {
            return this.action(fn.apply(new NodeInfoAction.Builder()).build());
        }

        public Builder client(NodeInfoClient value) {
            this.client = value;
            return this;
        }

        public Builder client(Function<NodeInfoClient.Builder, ObjectBuilder<NodeInfoClient>> fn) {
            return this.client(fn.apply(new NodeInfoClient.Builder()).build());
        }

        public Builder http(NodeInfoSettingsHttp value) {
            this.http = value;
            return this;
        }

        public Builder http(Function<NodeInfoSettingsHttp.Builder, ObjectBuilder<NodeInfoSettingsHttp>> fn) {
            return this.http(fn.apply(new NodeInfoSettingsHttp.Builder()).build());
        }

        public Builder bootstrap(@Nullable NodeInfoBootstrap value) {
            this.bootstrap = value;
            return this;
        }

        public Builder bootstrap(Function<NodeInfoBootstrap.Builder, ObjectBuilder<NodeInfoBootstrap>> fn) {
            return this.bootstrap(fn.apply(new NodeInfoBootstrap.Builder()).build());
        }

        public Builder transport(NodeInfoSettingsTransport value) {
            this.transport = value;
            return this;
        }

        public Builder transport(Function<NodeInfoSettingsTransport.Builder, ObjectBuilder<NodeInfoSettingsTransport>> fn) {
            return this.transport(fn.apply(new NodeInfoSettingsTransport.Builder()).build());
        }

        public Builder network(@Nullable NodeInfoSettingsNetwork value) {
            this.network = value;
            return this;
        }

        public Builder network(Function<NodeInfoSettingsNetwork.Builder, ObjectBuilder<NodeInfoSettingsNetwork>> fn) {
            return this.network(fn.apply(new NodeInfoSettingsNetwork.Builder()).build());
        }

        public Builder xpack(@Nullable NodeInfoXpack value) {
            this.xpack = value;
            return this;
        }

        public Builder xpack(Function<NodeInfoXpack.Builder, ObjectBuilder<NodeInfoXpack>> fn) {
            return this.xpack(fn.apply(new NodeInfoXpack.Builder()).build());
        }

        public Builder script(@Nullable NodeInfoScript value) {
            this.script = value;
            return this;
        }

        public Builder script(Function<NodeInfoScript.Builder, ObjectBuilder<NodeInfoScript>> fn) {
            return this.script(fn.apply(new NodeInfoScript.Builder()).build());
        }

        public Builder search(@Nullable NodeInfoSearch value) {
            this.search = value;
            return this;
        }

        public Builder search(Function<NodeInfoSearch.Builder, ObjectBuilder<NodeInfoSearch>> fn) {
            return this.search(fn.apply(new NodeInfoSearch.Builder()).build());
        }

        public Builder ingest(@Nullable NodeInfoSettingsIngest value) {
            this.ingest = value;
            return this;
        }

        public Builder ingest(Function<NodeInfoSettingsIngest.Builder, ObjectBuilder<NodeInfoSettingsIngest>> fn) {
            return this.ingest(fn.apply(new NodeInfoSettingsIngest.Builder()).build());
        }

        @Override
        public NodeInfoSettings build() {
            return new NodeInfoSettings(this);
        }
    }
}

